﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using System.Web.Mvc;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 星级评价
    /// </summary>
    public partial class SPBHtmlHelper
    {

        /// <summary>
        /// 显示星级评价
        /// </summary>
        /// <param name="ratingValue">当前评价星级</param>
        public string ShowRating(int ratingSum, int totalRatings)
        {
            return ShowRating(ratingSum, totalRatings, false, false);
        }

        /// <summary>
        /// 显示星级评价
        /// </summary>
        /// <param name="ratingValue">当前评价星级</param>
        /// <param name="totalRatings">总评价人数</param>
        /// <param name="showTotalRatings">是否显示总评价人数提示信息</param>
        public string ShowRating(int ratingSum, int totalRatings, bool showTotalRatings, bool isBig)
        {
            int totalStars = 5;
            int ratingValue = 0;

            if (ratingSum != 0 && totalRatings != 0)
            {
                //ratingValue = Convert.ToInt32((Double)ratingSum / (Double)totalRatings);
                ratingValue = ratingSum / totalRatings;
            }

            TagBuilder containerTagBuilder;
            TagBuilder starsTagBuilder;
            if (isBig)
            {
                starsTagBuilder = new TagBuilder("div");
                containerTagBuilder = new TagBuilder("div");
            }
            else
            {
                starsTagBuilder = new TagBuilder("span");
                containerTagBuilder = new TagBuilder("span");
                if (totalRatings > 0)
                    containerTagBuilder.MergeAttribute("title", string.Format("{0}人参与评价", totalRatings));
            }
            containerTagBuilder.MergeAttribute("class", "tn-rating-show");
            starsTagBuilder.AddCssClass("tn-rating-show-average");
            starsTagBuilder.MergeAttribute("style", string.Format("width:{0}%", ratingValue * 100 / totalStars));
            containerTagBuilder.InnerHtml = starsTagBuilder.ToString();

            StringBuilder htmlString = new StringBuilder();
            htmlString.Append(containerTagBuilder.ToString());

            if (showTotalRatings && totalRatings > 0)
            {
                TagBuilder messageTagBuilder = new TagBuilder("span");
                messageTagBuilder.InnerHtml = string.Format("[{0}人参与评价]", totalRatings);
                htmlString.Append(messageTagBuilder.ToString());
            }

            return htmlString.ToString();
        }
        /// <summary>
        /// 星级评价按钮
        /// </summary>
        /// <param name="itemID">需评价的itemID</param>
        /// <param name="name">星级评价按钮 name</param>
        /// <param name="ratingSum">当前评价总分值</param>
        /// <param name="totalRatings">总评价人数</param>
        /// <param name="ratingUrl">处理评价操作的url</param>
        public string RatingButton(int itemID, string name, int ratingSum, int totalRatings, string ratingUrl)
        {
            return RatingButton(itemID, name, ratingSum, totalRatings, ratingUrl, string.Empty);
        }
        /// <summary>
        /// 星级评价按钮
        /// </summary>
        /// <param name="itemID">需评价的itemID</param>
        /// <param name="name">星级评价按钮 name</param>
        /// <param name="ratingSum">当前评价总分值</param>
        /// <param name="totalRatings">总评价人数</param>
        /// <param name="ratingUrl">处理评价操作的url</param>
        public string RatingButton(int itemID, string name, int ratingSum, int totalRatings, string ratingUrl, string ratingCallback)
        {
            int starCount = 5;
            int ratingValue = 0;
            string[] starTitles = { ResourceManager.GetString("Description_VeryPoor", Globals.GetCurrentUserLanguage()),
            ResourceManager.GetString("Description_Poor", Globals.GetCurrentUserLanguage()),
            ResourceManager.GetString("Description_General", Globals.GetCurrentUserLanguage()),
            ResourceManager.GetString("Description_Good", Globals.GetCurrentUserLanguage()),
            ResourceManager.GetString("Description_VeryGood", Globals.GetCurrentUserLanguage())
            };
            if (ratingSum != 0 && totalRatings != 0)
            {
                //ratingValue = Convert.ToInt32((Double)ratingSum / (Double)totalRatings);
                ratingValue = ratingSum / totalRatings;
            }
            string wrapperID = string.Format("{0}-wrapper", name);
            string messageID = string.Format("{0}-message", name);
            string capID = string.Format("{0}-cap", name);
            StringBuilder htmlString = new StringBuilder();
            htmlString.AppendFormat("<form><div id=\"{0}\">", wrapperID);
            for (int i = 0; i < starCount; i++)
            {
                htmlString.AppendFormat("<input type=\"radio\" name=\"{0}\" value=\"{1}\" title=\"{2}\" ", name, i + 1, starTitles[i]);

                if (ratingValue == i + 1)
                    htmlString.Append("checked=\"checked\" />");
                else
                    htmlString.Append(" />");
            }
            htmlString.AppendFormat("</div><span class=\"ui-stars-cap\" id=\"{0}\"></span><span class=\"ui-stars-message\" id=\"{1}\"></span></form>", capID, messageID);
            htmlString.AppendLine("<script type=\"text/javascript\">");
            htmlString.AppendLine(" $(document).ready(function() {");

            if (totalRatings > 0)
                htmlString.AppendFormat(" $(\"#{0}\").html(\"{1}\");", messageID, string.Format(ResourceManager.GetString("Description_Pattern_RatingUserCount", Globals.GetCurrentUserLanguage()), totalRatings));

            htmlString.AppendLine();
            htmlString.AppendFormat(" $(\"#{0}\")", wrapperID);
            htmlString.AppendFormat(".stars({{cancelShow: true,captionEl: $(\"#{0}\"), oneVoteOnly: true,callback: function(ui, type, ratingValue){{", capID);
            htmlString.AppendFormat(" $.get('{0}',", ratingUrl);
            htmlString.AppendFormat("{{ Action:'get',itemID:'{0}',value:ratingValue }}", itemID);

            htmlString.Append(" ,function(data){ ");
            htmlString.AppendFormat(" $('#{0}').stars('select',({1}*{2}+ratingValue)/({1}+1));  $('#{3}').html('['+ data +']');", wrapperID, totalRatings, ratingValue, messageID);
            if (!string.IsNullOrEmpty(ratingCallback))
                htmlString.AppendFormat(" {0};", ratingCallback);
            htmlString.Append(" setTimeout(function(){ ");
            htmlString.AppendFormat(" $('#{0}').html('{1}'); ", messageID, string.Format(ResourceManager.GetString("Description_Pattern_RatingUserCount", Globals.GetCurrentUserLanguage()), totalRatings + 1));
            htmlString.Append(" },2000); });");
            htmlString.Append(" }}); }); </script>");

            return htmlString.ToString();
        }
    }
}