﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;
using System.Web.Mvc;
using System.Web.Routing;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {

        ///<overloads>操作提示信息</overloads>
        /// <summary>
        /// 操作提示信息
        /// </summary>
        /// <param name="statusMessageData">辅助传输StatusMessage数据</param>
        public string StatusMessage(StatusMessageData statusMessageData)
        {
            return StatusMessage(statusMessageData.MessageType, statusMessageData.MessageContent, -1, false);
        }
        ///<overloads>操作提示信息</overloads>
        /// <summary>
        /// 操作提示信息
        /// </summary>
        /// <param name="statusMessageData">辅助传输StatusMessage数据</param>
        ///         /// <param name="millisecondForHide">提示信息是否自动隐藏的毫秒数(-1=不自动隐藏)</param>
        public string StatusMessage(StatusMessageData statusMessageData, int millisecondForHide, bool isShowInDialog)
        {
            return StatusMessage(statusMessageData.MessageType, statusMessageData.MessageContent, millisecondForHide, isShowInDialog);
        }

        ///<overloads>操作提示信息</overloads>
        /// <summary>
        /// 操作提示信息
        /// </summary>
        /// <param name="messageType">提示信息类别</param>
        /// <param name="messageContent">提示信息内容(可以是html代码)</param>
        public string StatusMessage(StatusMessageType messageType, string messageContent)
        {
            return StatusMessage(messageType, messageContent, null, -1, false);
        }

        ///<overloads>操作提示信息</overloads>
        /// <summary>
        /// 操作提示信息
        /// </summary>
        /// <param name="messageType">提示信息类别</param>
        /// <param name="messageContent">提示信息内容(可以是html代码)</param>
        /// <param name="millisecondForHide">提示信息是否自动隐藏的毫秒数(-1=不自动隐藏)</param>
        public string StatusMessage(StatusMessageType messageType, string messageContent, int millisecondForHide)
        {
            return StatusMessage(messageType, messageContent, null, millisecondForHide, false);
        }
        ///<overloads>操作提示信息</overloads>
        /// <summary>
        /// 操作提示信息
        /// </summary>
        /// <param name="messageType">提示信息类别</param>
        /// <param name="messageContent">提示信息内容(可以是html代码)</param>
        /// <param name="millisecondForHide">提示信息是否自动隐藏的毫秒数(-1=不自动隐藏)</param>
        public string StatusMessage(StatusMessageType messageType, string messageContent, bool isShowInDialog)
        {
            return StatusMessage(messageType, messageContent, null, -1, isShowInDialog);
        }
        ///<overloads>操作提示信息</overloads>
        /// <summary>
        /// 操作提示信息
        /// </summary>
        /// <param name="messageType">提示信息类别</param>
        /// <param name="messageContent">提示信息内容(可以是html代码)</param>
        /// <param name="millisecondForHide">提示信息是否自动隐藏的毫秒数(-1=不自动隐藏)</param>
        public string StatusMessage(StatusMessageType messageType, string messageContent, int millisecondForHide, bool isShowInDialog)
        {
            return StatusMessage(messageType, messageContent, null, millisecondForHide, isShowInDialog);
        }

        ///<overloads>操作提示信息</overloads>
        /// <summary>
        /// 操作提示信息
        /// </summary>
        /// <param name="messageType">提示信息类别</param>
        /// <param name="messageContent">提示信息内容(可以是html代码)</param>
        /// <param name="htmlAttributes">html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string StatusMessage(StatusMessageType messageType, string messageContent, RouteValueDictionary htmlAttributes)
        {
            return StatusMessage(messageType, messageContent, htmlAttributes, -1, false);
        }

        ///<overloads>操作提示信息</overloads>
        /// <summary>
        /// 操作提示信息
        /// </summary>
        /// <param name="messageType">提示信息类别</param>
        /// <param name="messageContent">提示信息内容(可以是html代码)</param>
        /// <param name="htmlAttributes">html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        /// <param name="millisecondForHide">提示信息是否自动隐藏的毫秒数(-1=不自动隐藏)</param>
        public string StatusMessage(StatusMessageType messageType, string messageContent, RouteValueDictionary htmlAttributes, int millisecondForHide, bool isShowInDialog)
        {
            string statusImageSrc = SPBHtmlHelper.Instance().Icon(IconTypes.AcceptCircle);

            string strongInfo = string.Empty;
            string className = string.Empty;
            string iconName = "succeed";
            switch (messageType)
            {
                case StatusMessageType.Success:
                    statusImageSrc = SPBHtmlHelper.Instance().Icon(IconTypes.AcceptCircle, string.Empty);// "~/Themes/Shared/Styles/Images/status_success.gif";
                    className = "tn-cue-success tn-corner-all tn-message-box";
                    strongInfo = "完成： ";
                    break;
                case StatusMessageType.Error:
                    statusImageSrc = SPBHtmlHelper.Instance().Icon(IconTypes.CrossCircle, string.Empty);// "~/Themes/Shared/Styles/Images/status_Error.gif";
                    className = "tn-cue-error tn-corner-all tn-message-box";
                    iconName = "error";
                    strongInfo = "错误： ";
                    break;
                case StatusMessageType.Hint:
                    statusImageSrc = SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation, string.Empty);// "~/Themes/Shared/Styles/Images/status_Hint.gif";
                    className = "tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray";
                    iconName = "alert";
                    strongInfo = "提示： ";
                    break;
            }
            TagBuilder containerdiv = new TagBuilder("div");
            containerdiv.AddCssClass("tn-widget");
            containerdiv.MergeAttribute("name", "statusMessage");
            TagBuilder container = new TagBuilder("div");
            TagBuilder margin = new TagBuilder("div");
            margin.AddCssClass("tn-blank10");

            string spanLeft = string.Format("<span class=\"tn-helper-left\">{0}</span>", statusImageSrc);
            string spanRight = string.Empty;
            if (messageType != StatusMessageType.Hint)
                spanRight = string.Format("<span class=\"tn-helper-right\"><a class=\"tn-icon tn-icon-cross\" href=\"javascript:;\"></a></span>");
            string strong = string.Format("<div class=\"tn-helper-flowfix\"> <strong>{0}</strong>{1}</div>", strongInfo, messageContent);
            container.AddCssClass(className);

            if (htmlAttributes != null)
                container.MergeAttributes(htmlAttributes);
            if (isShowInDialog)
                container.InnerHtml = spanLeft + strong;
            else
                container.InnerHtml = spanRight + spanLeft + strong;
            StringBuilder script = new StringBuilder();
            script.Append("<script type=\"text/javascript\">$(document).ready(function(){");
            if (millisecondForHide > 0)
            {
                if (isShowInDialog)
                    script.AppendFormat("$.dialog({{id:'statusMessageDialog', icon:'{0}' , time:{1}, content:'{2}',yesFn: true }});", iconName, millisecondForHide, messageContent);
                else
                    script.AppendFormat("setTimeout(function(){{ $(\"div[name='statusMessage']\").fadeOut(\"normal\"); }},{0});", millisecondForHide);
            }
            else
            {
                if (isShowInDialog)
                    script.AppendFormat("$.dialog({{id:'statusMessageDialog',icon:'{0}',content:'{1}',yesFn: true }});", iconName, messageContent);
            }
            script.Append("$(\"a.tn-icon-cross\").click(function(){");
            script.Append("$(\"div[name='statusMessage']\").fadeOut(\"normal\"); ");
            script.Append("}); ");


            script.Append("});</script>");
            containerdiv.InnerHtml = container.ToString() + "\n" + margin.ToString();
            if (isShowInDialog)
                return script.ToString();
            else
                return containerdiv.ToString() + script.ToString();
        }
    }

    /// <summary>
    /// 辅助传输StatusMessage数据
    /// </summary>
    public sealed class StatusMessageData
    {
        private StatusMessageType messageType;
        /// <summary>
        /// 提示消息类别
        /// </summary>
        public StatusMessageType MessageType
        {
            get { return messageType; }
            set { messageType = value; }
        }

        private string messageContent = string.Empty;
        /// <summary>
        /// 信息内容
        /// </summary>
        public string MessageContent
        {
            get { return messageContent; }
            set { messageContent = value; }
        }

        public StatusMessageData(StatusMessageType messageType, string messageContent)
        {
            this.messageType = messageType;
            this.messageContent = messageContent;
        }
    }


    /// <summary>
    /// 提示消息类别
    /// </summary>
    public enum StatusMessageType
    {
        /// <summary>
        /// 成功
        /// </summary>
        Success = 1,

        /// <summary>
        /// 错误
        /// </summary>
        Error = -1,

        /// <summary>
        /// 提示信息
        /// </summary>
        Hint = 0
    }
}
