﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using System.Web.Routing;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {

        /// <summary>
        /// 标签输入
        /// </summary>
        /// <param name="name">生成的input的name及id</param>
        /// <param name="value">input显示的内容</param>
        /// <param name="tagSuggestionUrl">用于tag提示的url</param>
        public string TagInput(string name, string value, string tagSuggestionUrl)
        {
            return TagInput(name, value, tagSuggestionUrl, null);
        }

        /// <summary>
        /// 标签输入
        /// </summary>
        /// <param name="name">生成的input的name及id</param>
        /// <param name="value">input显示的内容</param>
        /// <param name="tagSuggestionUrl">用于tag提示的url</param>
        /// <param name="htmlAttributes">input的html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string TagInput(string name, string value, string tagSuggestionUrl, RouteValueDictionary htmlAttributes)
        {
            StringBuilder htmlString = new StringBuilder();

            TagBuilder inputBuilder = new TagBuilder("input");
            if (htmlAttributes != null)
                inputBuilder.MergeAttributes(htmlAttributes);

            inputBuilder.MergeAttribute("name", name);
            inputBuilder.MergeAttribute("id", name);
            inputBuilder.MergeAttribute("autocomplete", "off");

            if (!string.IsNullOrEmpty(value))
                inputBuilder.MergeAttribute("value", value);

            htmlString.Append(inputBuilder.ToString(TagRenderMode.SelfClosing));


            //TagBuilder tagSuggestionContainerBuilder = new TagBuilder("span");
            //tagSuggestionContainerBuilder.MergeAttribute("class", "tagMatches");
            //htmlString.Append(tagSuggestionContainerBuilder.ToString(TagRenderMode.Normal));


            htmlString.AppendLine("<script type=\"text/javascript\"> \n\r  $(document).ready(function() {");
            htmlString.AppendFormat(" $('#{0}').tagSuggest({{separator:',', url: '{1}', delay: 250}});", name, tagSuggestionUrl);
            htmlString.AppendLine();
            htmlString.Append(" }); </script>");

            return htmlString.ToString();
        }
        /// <summary>
        /// 显示站点标签链接
        /// </summary>
        /// <param name="siteTag">站点标签</param>
        /// <param name="url"></param>
        /// <returns></returns>
        public string ShowSiteTagHyperLink(SiteTag siteTag, string hrefUrl, string titlePattern)
        {
            TagBuilder a = new TagBuilder("a");
            a.MergeAttribute("href", hrefUrl);
            a.MergeAttribute("title", string.Format(titlePattern, siteTag.UserCount, siteTag.ItemCount));
            a.InnerHtml = StringUtils.Trim(siteTag.TagName, 12);
            return a.ToString();
        }

        public string ShowSiteTagMapHyperLink(SiteTag siteTag, string hrefUrl, string titlePattern)
        {
            TagBuilder a = new TagBuilder("a");
            a.MergeAttribute("href", hrefUrl);
            a.MergeAttribute("title", string.Format(titlePattern, siteTag.UserCount, siteTag.ItemCount));
            a.InnerHtml = StringUtils.Trim(siteTag.TagName, 12);
            return a.ToString();
        }
    }
}
