﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

using SpaceBuilder.Common;
using System.Web.Mvc;
using System.Web.Routing;
using SpaceBuilder.Utils;
using System.Collections;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {

        ///<overloads>显示用户头像</overloads>
        /// <summary>
        /// 显示用户头像
        /// </summary>
        /// <param name="userID">userID</param>
        /// <param name="avatarSizeTypes">头像尺寸类别</param>
        public string ShowUserAvatar(int userID, AvatarSizeTypes avatarSizeTypes)
        {
            User user = Users.GetUser(userID, false);
            return ShowUserAvatar(user, avatarSizeTypes);
        }

        /// <summary>
        /// 根据用户userName显示用户头像
        /// </summary>
        /// <param name="userName">用户userName</param>
        /// <param name="avatarSizeTypes">头像尺寸类别</param>
        public string ShowUserAvatar(string userName, AvatarSizeTypes avatarSizeTypes)
        {
            User user = Users.GetUser(userName, false);
            if (user == null)
                throw new ArgumentException(string.Format(ResourceManager.GetString("Exception_Pattern_UserNotFound", Globals.GetCurrentUserLanguage()), userName));
            return ShowUserAvatar(user, avatarSizeTypes);
        }

        /// <summary>
        /// 根据用户userName显示用户头像
        /// </summary>
        /// <param name="userName">用户userName</param>
        /// <param name="enableNavigate">是否允许链接到用户空间</param>
        /// <param name="navigateTarget">frameName 或者 _blank,_parent,_search,_self,_to</param>
        /// <param name="avatarSizeTypes">头像尺寸类别</param>
        public string ShowUserAvatar(string userName, bool enableNavigate, HyperLinkTarget navigateTarget, AvatarSizeTypes avatarSizeTypes)
        {
            return ShowUserAvatar(userName, enableNavigate, navigateTarget, avatarSizeTypes, true, null);
        }
        /// <summary>
        /// 根据用户userName显示用户头像
        /// </summary>
        /// <param name="userName">用户userName</param>
        /// <param name="enableNavigate">是否允许链接到用户空间</param>
        /// <param name="navigateTarget">frameName 或者 _blank,_parent,_search,_self,_to</param>
        /// <param name="avatarSizeTypes">头像尺寸类别</param>
        /// <param name="enableCachingInClient">是否允许在客户端缓存</param>
        public string ShowUserAvatar(string userName, bool enableNavigate, HyperLinkTarget navigateTarget, AvatarSizeTypes avatarSizeTypes, bool enableCachingInClient)
        {
            return ShowUserAvatar(userName, enableNavigate, navigateTarget, avatarSizeTypes, enableCachingInClient, null);
        }
        /// <summary>
        /// 根据用户userName显示用户头像
        /// </summary>
        /// <param name="userName">用户userName</param>
        /// <param name="enableNavigate">是否允许链接到用户空间</param>
        /// <param name="navigateTarget">frameName 或者 _blank,_parent,_search,_self,_to</param>
        /// <param name="avatarSizeTypes">头像尺寸类别</param>
        /// <param name="enableCachingInClient">是否允许在客户端缓存</param>
        /// <param name="htmlAttributes">html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string ShowUserAvatar(string userName, bool enableNavigate, HyperLinkTarget navigateTarget, AvatarSizeTypes avatarSizeTypes, bool enableCachingInClient, RouteValueDictionary htmlAttributes)
        {
            User user = Users.GetUser(userName, false);
            return ShowUserAvatar(user, enableNavigate, navigateTarget, avatarSizeTypes, enableCachingInClient, htmlAttributes);
        }

        ///<overloads>显示用户头像</overloads>
        /// <summary>
        /// 显示用户头像
        /// </summary>
        /// <param name="userID">userID</param>
        /// <param name="enableNavigate">是否允许链接到用户空间</param>
        /// <param name="navigateTarget">frameName 或者 _blank,_parent,_search,_self,_top</param>
        /// <param name="avatarSizeTypes">头像尺寸类别</param>
        public string ShowUserAvatar(int userID, bool enableNavigate, HyperLinkTarget navigateTarget, AvatarSizeTypes avatarSizeTypes)
        {
            return ShowUserAvatar(userID, enableNavigate, navigateTarget, avatarSizeTypes, null);
        }

        ///<overloads>显示用户头像</overloads>
        /// <summary>
        /// 显示用户头像
        /// </summary>
        /// <param name="userID">userID</param>
        /// <param name="enableNavigate">是否允许链接到用户空间</param>
        /// <param name="navigateTarget">frameName 或者 _blank,_parent,_search,_self,_top</param>
        /// <param name="avatarSizeTypes">头像尺寸类别</param>
        /// <param name="htmlAttributes">html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string ShowUserAvatar(int userID, bool enableNavigate, HyperLinkTarget navigateTarget, AvatarSizeTypes avatarSizeTypes, RouteValueDictionary htmlAttributes)
        {
            User user = Users.GetUser(userID, false);
            return ShowUserAvatar(user, enableNavigate, navigateTarget, avatarSizeTypes, true, htmlAttributes);
        }



        ///<overloads>显示用户头像</overloads>
        /// <summary>
        /// 显示用户头像
        /// </summary>
        /// <param name="user">User</param>
        /// <param name="width">头像宽度</param>
        /// <param name="height">头像高度</param>
        /// <returns></returns>
        public string ShowUserAvatar(User user, AvatarSizeTypes avatarSizeTypes)
        {
            return ShowUserAvatar(user, true, HyperLinkTarget._self, avatarSizeTypes, true, null);
        }

        ///<overloads>显示用户头像</overloads>
        /// <summary>
        /// 显示用户头像
        /// </summary>
        /// <param name="user">User</param>
        /// <param name="enableNavigate">是否允许链接到用户空间</param>
        /// <param name="navigateTarget">frameName 或者 _blank,_parent,_search,_self,_top</param>
        /// <param name="avatarSizeTypes">头像尺寸类别</param>
        /// <param name="enableCachingInClient">是否允许在客户端缓存</param>
        /// <param name="htmlAttributes">html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string ShowUserAvatar(User user, bool enableNavigate, HyperLinkTarget navigateTarget, AvatarSizeTypes avatarSizeTypes, bool enableCachingInClient, RouteValueDictionary htmlAttributes)
        {
            string avatarUrl = SiteUrls.Instance().UserAvatarUrl(user != null ? user.UserID : 0, avatarSizeTypes, enableCachingInClient);

            TagBuilder img = new TagBuilder("img");
            if (htmlAttributes != null)
                img.MergeAttributes(htmlAttributes);

            img.MergeAttribute("src", avatarUrl);
            if (user != null)
            {
                img.MergeAttribute("alt", user.DisplayName);
                img.MergeAttribute("title", user.DisplayName);
            }
            TagBuilder span = new TagBuilder("span");
            span.AddCssClass("tn-round-corner");

            if (enableNavigate && user != null)
            {
                TagBuilder a = new TagBuilder("a");
                a.MergeAttribute("href", SiteUrls.Instance().UserDomainHome(user.UserName));

                if (navigateTarget != HyperLinkTarget._self)
                    a.MergeAttribute("target", navigateTarget.ToString());

                a.InnerHtml = img.ToString(TagRenderMode.SelfClosing) + span.ToString();

                return a.ToString();
            }
            else
            {
                return img.ToString(TagRenderMode.SelfClosing) + span.ToString();
            }
        }


        /// <summary>
        /// 显示用户是否在线图标
        /// </summary>
        /// <param name="isOnline">是否在线</param>
        public string ShowUserOnlineIcon(bool isOnline)
        {
            TagBuilder imageTag = new TagBuilder("img");
            if (isOnline)
            {
                imageTag.MergeAttribute("src", Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/user_IsOnline.gif"));
                imageTag.MergeAttribute("alt", "在线");
                imageTag.MergeAttribute("title", "在线");
            }
            else
            {
                imageTag.MergeAttribute("src", Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/user_IsOffline.gif"));
                imageTag.MergeAttribute("alt", "离线");
                imageTag.MergeAttribute("title", "离线");
            }
            return imageTag.ToString(TagRenderMode.SelfClosing);
        }


        /// <summary>
        /// 获取等级标识图片
        /// </summary>
        public string ShowUserRankIcons(User user)
        {
            return ShowUserRankIcons(user, null);
        }

        /// <summary>
        /// 获取等级标识图片
        /// </summary>
        public string ShowUserRankIcons(User user, RouteValueDictionary htmlAttributes)
        {
            if (user == null)
                return string.Empty;
            UserRank u = UserRanks.GetUserRank(user.Rank, false);
            TagBuilder span = new TagBuilder("span");
            span.MergeAttributes(htmlAttributes);
            span.MergeAttribute("title", u.GetUserRankName(user.RankType));

            List<string> rankIconUrls = user.RankIconUrls;
            foreach (string rankIconUrl in rankIconUrls)
            {
                TagBuilder img = new TagBuilder("img");
                img.MergeAttribute("src", Globals.GetFullUrlInResourceSite(rankIconUrl));
                span.InnerHtml += img.ToString();
            }

            return span.ToString();
        }

        /// <summary>
        /// 显示用户特殊角色标识图片
        /// </summary>
        public string ShowUserRoleIcons(User user)
        {
            return ShowUserRoleIcons(user, null);
        }
        /// <summary>
        /// 显示用户特殊角色标识图片
        /// </summary>
        public string ShowUserRoleIcons(User user, RouteValueDictionary htmlAttributes)
        {
            if (user.PublicRoles.Count == 0)
                return string.Empty;
            TagBuilder span = new TagBuilder("span");
            span.MergeAttributes(htmlAttributes);
            string roleIconPattern = SPBConfig.Instance().RoleIconPattern;

            foreach (Role role in user.PublicRoles)
            {
                TagBuilder img = new TagBuilder("img");
                img.MergeAttribute("src", Globals.GetFullUrlInResourceSite(string.Format(roleIconPattern, role.RoleName)));
                img.MergeAttribute("title", role.FriendlyRoleName);
                img.MergeAttribute("alt", role.FriendlyRoleName);
                span.InnerHtml += img.ToString();
            }
            return span.ToString();
        }

        ///// <summary>
        ///// 格式化用户的个性签名
        ///// </summary>
        ///// <param name="userSignature">格式化前的个性签名</param>
        ///// <returns>格式化后的个性签名</returns>
        //public string FormatSignature(string userSignature)
        //{
        //    if (!string.IsNullOrEmpty(userSignature))
        //    {
        //        //return "<hr size=\"1\" align=\"left\" width=\"25%\">" + userSignature.Replace("\r\n", "<br>");
        //        return userSignature.Replace("\r\n", "<br>");
        //    }
        //    else
        //    {
        //        return String.Empty;
        //    }
        //}

        /// <summary>
        /// 获取带链接的显示用户DisplayName的html代码
        /// </summary>
        public string UserDisplayNameLink(User user)
        {
            if (user == null)
                return UserDisplayNameLink(0, string.Empty);
            return UserDisplayNameLink(user.UserID, user.DisplayName);
        }
        /// <summary>
        /// 获取带链接的显示用户DisplayName的html代码
        /// </summary>
        public string UserDisplayNameLink(User user, bool showIdentity)
        {
            if (user == null)
                return UserDisplayNameLink(0, string.Empty, showIdentity);
            return UserDisplayNameLink(user.UserID, user.DisplayName, showIdentity);
        }

        /// <summary>
        /// 获取带链接的显示用户DisplayName的html代码
        /// </summary>      
        public string UserDisplayNameLink(int userID, string userDisplayName)
        {
            return UserDisplayNameLink(userID, userDisplayName, null, false);
        }
        /// <summary>
        /// 获取带链接的显示用户DisplayName的html代码
        /// </summary>      
        public string UserDisplayNameLink(int userID, string userDisplayName, bool showIdentity)
        {
            return UserDisplayNameLink(userID, userDisplayName, null, showIdentity);
        }
        /// <summary>
        /// 获取带链接的显示用户DisplayName的html代码
        /// </summary>      
        public string UserDisplayNameLink(int userID, string userDisplayName, int? applicationID)
        {
            return UserDisplayNameLink(userID, userDisplayName, null, false);
        }


        /// <summary>
        /// 获取带链接的显示用户DisplayName的html代码
        /// </summary>      
        public string UserDisplayNameLink(int userID, string userDisplayName, int? applicationID, bool showIdentity)
        {
            if (userID <= 0)
                if (!string.IsNullOrEmpty(userDisplayName))
                    return userDisplayName;
                else
                    return ResourceManager.GetString("Common_AnonymousDisplayName", Globals.GetCurrentUserLanguage());
            string hyperlinkTargetOfUserActivity = "target=\"_blank\"";
            string linkUrl = string.Empty;
            if (applicationID == null)
                linkUrl = SiteUrls.Instance().UserDomainHome(userID);
            else
                linkUrl = SiteUrls.Instance().UserChannelHome(userID, applicationID.Value);

            string innerText = StringUtils.Trim(userDisplayName, 5);
            if (showIdentity)
            {
                UserIdentity userIdentity = Identities.GetUserIdentity(userID, true);

                if (userIdentity != null)
                {
                    string src = SiteUrls.Instance().IdentityIcon(userIdentity.Identity, IdentityIconTypes.Small);
                    innerText = innerText + string.Format("<img src='{0}' title='{1}' />", src, userIdentity.IdentityDescription);
                }
            }
            return string.Format("<a class=\"tn-author\" {0} href=\"{1}\" title=\"{3}\">{2}</a>", hyperlinkTargetOfUserActivity, linkUrl, innerText, userDisplayName);
        }

        /// <summary>
        /// 获取DisplayName,不输出身份标识
        /// </summary>
        public string UserDisplayName(User user)
        {
            if (user == null)
                return ResourceManager.GetString("Common_AnonymousDisplayName", Globals.GetCurrentUserLanguage());
            return (user.DisplayName);

        }
        /// <summary>
        /// 获取DisplayName,输出身份标识
        /// </summary>
        public string UserDisplayName(int userID, bool showIdentity)
        {
            User user = Users.GetUser(userID, false);
            if (user == null)
                return ResourceManager.GetString("Common_AnonymousDisplayName", Globals.GetCurrentUserLanguage());
            SiteSettings setting = SiteSettingsManager.GetSiteSettings();
            if (showIdentity && setting.EnableUserIdentity)
            {
                UserIdentity userIdentity = Identities.GetUserIdentity(userID, true);
                if (userIdentity != null)
                {
                    string src = SiteUrls.Instance().IdentityIcon(userIdentity.Identity, IdentityIconTypes.Small);
                    return user.DisplayName + string.Format("<img src='{0}'  class='spb-icon-v' title='{1}'/>", src, userIdentity.IdentityDescription);
                }
            }
            return (user.DisplayName);

        }

        /// <summary>
        /// 获取DisplayName
        /// </summary>
        public string UserDisplayName(int userID)
        {
            User user = Users.GetUser(userID, false);
            return UserDisplayName(user);
        }
    }
}