﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Routing;
using SpaceBuilder.Common;
using System.Web.Mvc;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {
        public string ShowVerificationCode(string verifyCodeText, VerificationCodeDifficultyLevel level)
        {
            return ShowVerificationCode(verifyCodeText, level, new RouteValueDictionary(), false, false);
        }
        public string ShowVerificationCode(string verifyCodeText, VerificationCodeDifficultyLevel level, bool isShowVerifyCodeImage)
        {
            return ShowVerificationCode(verifyCodeText, level, new RouteValueDictionary(), false, isShowVerifyCodeImage);
        }
        public string ShowVerificationCode(string verifyCodeText, VerificationCodeDifficultyLevel level, RouteValueDictionary htmlValue, bool isShowVerifyCodeImage)
        {
            return ShowVerificationCode(verifyCodeText, level, htmlValue, false, isShowVerifyCodeImage);
        }

        public string ShowVerificationCode(string verifyCodeText, VerificationCodeDifficultyLevel level, RouteValueDictionary htmlValue, bool isUseLineNoise, bool isShowVerifyCodeImage)
        {
            TagBuilder inputText = new TagBuilder("input");
            inputText.MergeAttribute("name", verifyCodeText);
            inputText.MergeAttribute("id", verifyCodeText);
            inputText.MergeAttribute("type", "type");
            inputText.MergeAttribute("class", "tn-textbox tn-input-short tn-border-gray");
            inputText.MergeAttribute("autocomplete", "off");
            inputText.MergeAttribute("maxlength", "6");
            inputText.MergeAttribute("size", "6");
            inputText.MergeAttributes(htmlValue);

            string tagID = "spanCode_" + verifyCodeText;
            string spanString = "<span id=\"" + tagID + "\" style=\"" + (isShowVerifyCodeImage ? "" : "display:none;") + "\">{0}</span>";
            string imgtagID = "codeImage_" + tagID;
            //string urlString = SPBUrlHelper.Action("ShowVerificationCodeImage", "Channel", new RouteValueDictionary() { { "level", level }, { "htmlValue", htmlValue }, { "IsUseLineNoise", IsUseLineNoise },{"tagID",tagID} });
            //string scriptString = string.Empty;
            //if (isShowVerifyCodeImage)
            //    scriptString = string.Format("<script type=\"text/javascript\"> $(document).ready(function()  {{ $(\"#{1}\").load('{0}'); }});</script>", urlString, tagID);
            //else
            //    scriptString = string.Format("<script type=\"text/javascript\"> $(document).ready(function() {{ $(\"#{0}\").focus(function() {{ $(\"#{2}\").load('{1}&jsr='+Math.round(Math.random()*10000)); }});}});</script>", verifyCodeText, urlString, tagID);
            //return inputText.ToString() + "&nbsp;" + spanString + scriptString;

            string strImgQueryingUrl = Globals.GetFullUrlInMainSite(string.Format("~/Services/VerifyCodeImage.ashx?level={0}&r={1}&lineNoise={2}", ((int)level).ToString(), new Random().Next(), isUseLineNoise));

            inputText.MergeAttribute("onfocus", "if($(\"#" + imgtagID + "\").attr(\"src\")==''){ $(\"#" + tagID + "\").show();$(\"#" + imgtagID + "\").attr(\"src\",\"" + strImgQueryingUrl + "\");}");

            return inputText.ToString() + "&nbsp;" + string.Format(spanString, GenerateImgCodeHtmlString(imgtagID, level, isUseLineNoise, isShowVerifyCodeImage, strImgQueryingUrl));
        }

        private string GenerateImgCodeHtmlString(string imgTagID, VerificationCodeDifficultyLevel level, bool isUseLineNoise, bool isShowVerifyCodeImage, string strImgQueryingUrl)
        {
            TagBuilder img = new TagBuilder("img");

            string altMessage = ResourceManager.GetString("Description_ChangeVerificationCodeImage", Globals.GetCurrentUserLanguage());

            img.MergeAttribute("id", imgTagID);
            img.MergeAttribute("src", isShowVerifyCodeImage ? strImgQueryingUrl : "");
            img.MergeAttribute("alt", altMessage);
            img.MergeAttribute("title", altMessage);
            string onclickString = "$('#" + imgTagID + "').attr('src','" + strImgQueryingUrl + "'+'&isremove=true&date='+new Date());return false;";
            img.MergeAttribute("onclick", onclickString);
            //img.MergeAttributes(htmlValue);

            string imgString = img.ToString(TagRenderMode.SelfClosing) + string.Format("<span class='tn-action'><a class='tn-action-text' href=\"javascript:;\" onclick=\"{1}\">{0}</a></span>", ResourceManager.GetString("Description_ChangeVerificationCodeImage"), onclickString);
            return imgString;
        }
    }
}
