﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Web;

using System.Data.SqlClient;
using SpaceBuilder.Common;
using System.Web.Mvc;
using System.Web.Routing;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {
        #region Instance
        private static volatile SPBHtmlHelper _instance = null;
        private static readonly object lockObject = new object();

        public static SPBHtmlHelper Instance()
        {
            if (_instance == null)
            {
                lock (lockObject)
                {
                    if (_instance == null)
                    {
                        _instance = new SPBHtmlHelper();
                    }
                }
            }
            return _instance;
        }

        private SPBHtmlHelper()
        { }
        #endregion

        /// <summary>
        /// 输出图标
        /// </summary>
        /// <param name="type">图标类型</param>
        public string Icon(IconTypes type)
        {
            return Icon(type, string.Empty, null);
        }

        /// <summary>
        /// 输出图标
        /// </summary>
        /// <param name="type">图标类型</param>
        public string Icon(IconTypes type, string title)
        {
            return Icon(type, title, null);
        }

        /// <summary>
        /// 输出图标
        /// </summary>
        public string Icon(IconTypes type, string title, RouteValueDictionary buttonHtmlAttributes)
        {
            TagBuilder span = new TagBuilder("span");
            span.AddCssClass("tn-icon");
            switch (type)
            {

                case IconTypes.TriangleUp:
                    span.AddCssClass("tn-icon-triangle-up");
                    break;
                case IconTypes.TriangleRight:
                    span.AddCssClass("tn-icon-triangle-right");
                    break;
                case IconTypes.TriangleDown:
                    span.AddCssClass("tn-icon-triangle-down");
                    break;
                case IconTypes.TriangleLeft:
                    span.AddCssClass("tn-icon-triangle-left");
                    break;


                case IconTypes.CollapseOpen:
                    span.AddCssClass("tn-icon-collapse-open");
                    break;
                case IconTypes.CollapseClose:
                    span.AddCssClass("tn-icon-collapse-close");
                    break;


                case IconTypes.Download:
                    span.AddCssClass("tn-icon-download");
                    break;
                case IconTypes.Upload:
                    span.AddCssClass("tn-icon-upload");
                    break;
                case IconTypes.Question:
                    span.AddCssClass("tn-icon-question");
                    break;

                case IconTypes.Add:
                    span.AddCssClass("tn-icon-add");
                    break;
                case IconTypes.Write:
                    span.AddCssClass("tn-icon-write");
                    break;
                case IconTypes.Update:
                    span.AddCssClass("tn-icon-update");
                    break;
                case IconTypes.Cross:
                    span.AddCssClass("tn-icon-cross");
                    break;
                case IconTypes.Accept:
                    span.AddCssClass("tn-icon-accept");
                    break;
                case IconTypes.Stop:
                    span.AddCssClass("tn-icon-stop");
                    break;
                case IconTypes.Set:
                    span.AddCssClass("tn-icon-set");
                    break;
                case IconTypes.Config:
                    span.AddCssClass("tn-icon-config");
                    break;



                case IconTypes.Elite:
                    span.AddCssClass("tn-icon-elite");
                    break;
                case IconTypes.Email:
                    span.AddCssClass("tn-icon-email");
                    break;
                case IconTypes.EmailOpen:
                    span.AddCssClass("tn-icon-email-open");
                    break;
                case IconTypes.Top:
                    span.AddCssClass("tn-icon-top");
                    break;
                case IconTypes.Flag:
                    span.AddCssClass("tn-icon-flag");
                    break;
                case IconTypes.Lock:
                    span.AddCssClass("tn-icon-lock");
                    break;
                case IconTypes.Key:
                    span.AddCssClass("tn-icon-key");
                    break;
                case IconTypes.Limit:
                    span.AddCssClass("tn-icon-limit");
                    break;

                case IconTypes.View:
                    span.AddCssClass("tn-icon-view");
                    break;
                case IconTypes.ThumbUp:
                    span.AddCssClass("tn-icon-thumb-up");
                    break;
                case IconTypes.ThumbDown:
                    span.AddCssClass("tn-icon-thumb-down");
                    break;
                case IconTypes.Share:
                    span.AddCssClass("tn-icon-share");
                    break;
                case IconTypes.Bubble:
                    span.AddCssClass("tn-icon-bubble");
                    break;
                case IconTypes.Favorite:
                    span.AddCssClass("tn-icon-favorite");
                    break;
                case IconTypes.Star:
                    span.AddCssClass("tn-icon-star");
                    break;
                case IconTypes.Feed:
                    span.AddCssClass("tn-icon-feed");
                    break;
                case IconTypes.User:
                    span.AddCssClass("tn-icon-user");
                    break;
                case IconTypes.UserAdd:
                    span.AddCssClass("tn-icon-user-add");
                    break;
                case IconTypes.UserAllow:
                    span.AddCssClass("tn-icon-user-allow");
                    break;
                case IconTypes.UserStop:
                    span.AddCssClass("tn-icon-user-stop");
                    break;
                case IconTypes.UserRelation:
                    span.AddCssClass("tn-icon-user-relation");
                    break;
                case IconTypes.UserAvatar:
                    span.AddCssClass("tn-icon-user-avatar");
                    break;
                case IconTypes.UserInvite:
                    span.AddCssClass(" tn-icon-user-invite");
                    break;
                case IconTypes.UserCard:
                    span.AddCssClass("tn-icon-user-card");
                    break;
                case IconTypes.BrowseList:
                    span.AddCssClass("tn-icon-browse-list");
                    break;
                case IconTypes.BrowseDetail:
                    span.AddCssClass("tn-icon-browse-detail");
                    break;
                case IconTypes.BrowseMedium:
                    span.AddCssClass("tn-icon-browse-medium");
                    break;
                case IconTypes.BrowseSmall:
                    span.AddCssClass("tn-icon-browse-small");
                    break;
                case IconTypes.BrowseSlide:
                    span.AddCssClass("tn-icon-browse-slide");
                    break;
                case IconTypes.Dress:
                    span.AddCssClass("tn-icon-dress");
                    break;
                case IconTypes.Jump:
                    span.AddCssClass("tn-icon-jump");
                    break;
                case IconTypes.Zomm:
                    span.AddCssClass("tn-icon-zomm");
                    break;
                case IconTypes.Camera:
                    span.AddCssClass("tn-icon-camera");
                    break;
                case IconTypes.Alert:
                    span.AddCssClass("tn-icon-alert");
                    break;
                case IconTypes.Exclamation:
                    span.AddCssClass("tn-icon-exclamation");
                    break;
                case IconTypes.CrossCircle:
                    span.AddCssClass("tn-icon-cross-circle");
                    break;
                case IconTypes.AcceptCircle:
                    span.AddCssClass("tn-icon-accept-circle");
                    break;
                case IconTypes.Apply:
                    span.AddCssClass("tn-icon-apply");
                    break;
                case IconTypes.Logout:
                    span.AddCssClass("tn-icon-logout");
                    break;
                case IconTypes.Join:
                    span.AddCssClass("tn-icon-join");
                    break;
                case IconTypes.Quit:
                    span.AddCssClass("tn-icon-quit");
                    break;
                case IconTypes.Emotion:
                    span.AddCssClass("tn-icon-emotion");
                    break;
                case IconTypes.PaperClip:
                    span.AddCssClass("tn-icon-paper-clip");
                    break;
                case IconTypes.Picture:
                    span.AddCssClass("tn-icon-picture");
                    break;
                case IconTypes.Event:
                    span.AddCssClass("tn-icon-event");
                    break;
                case IconTypes.UserGroup:
                    span.AddCssClass("tn-icon-user-group");
                    break;
                case IconTypes.Find:

                case IconTypes.Archive:
                    span.AddCssClass("tn-icon-archive");
                    break;
                case IconTypes.Movie:
                    span.AddCssClass("tn-icon tn-icon-movie");
                    break;
                case IconTypes.Sound:
                    span.AddCssClass("tn-icon tn-icon-sound");
                    break;
                case IconTypes.Music:
                    span.AddCssClass("tn-icon tn-icon-music");
                    break;
                case IconTypes.World:
                    span.AddCssClass("tn-icon tn-icon-world");
                    break;
                case IconTypes.Coins:
                    span.AddCssClass("tn-icon tn-icon-coins tn-icon-inline");
                    break;
                case IconTypes.Topic:
                    span.AddCssClass("tn-icon tn-icon-topic");
                    break;
                case IconTypes.Fire:
                    span.AddCssClass("tn-icon tn-icon-fire");
                    break;
                case IconTypes.QuotesBefore:
                    span.AddCssClass("tn-icon tn-icon-quotes-before");
                    break;
                case IconTypes.Color:
                    span.AddCssClass("tn-icon tn-icon-color");
                    break;
                case IconTypes.App:
                    span.AddCssClass("tn-icon tn-icon-app");
                    break;
                case IconTypes.Play:
                    span.AddCssClass("tn-icon tn-icon-play");
                    break;
                case IconTypes.Pause:
                    span.AddCssClass("tn-icon tn-icon-pause");
                    break;
                default:
                    break;
            }
            span.MergeAttribute("title", title);
            if (buttonHtmlAttributes != null)
            {
                if (buttonHtmlAttributes.Any(n => n.Key.ToLower() == "class"))
                    span.AddCssClass(buttonHtmlAttributes.Single(n => n.Key.ToLower() == "class").Value.ToString());
            }
            span.MergeAttributes(buttonHtmlAttributes);
            return span.ToString();
        }

        /// <summary>
        /// 输出普通按钮
        /// 仅显示图标
        /// </summary>
        public string Button(string buttonID, HighlightStyles highlightStyle, IconTypes iconType, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            return Button(buttonID, string.Empty, ButtonSizes.Default, highlightStyle, iconType, TextIconLayout.IconOnly, buttonHtmlAttributes, outerSpanHtmlAttributes);
        }

        /// <summary>
        /// 输出普通按钮
        /// 仅显示文字
        /// </summary>
        public string Button(string buttonID, string buttonText, ButtonSizes size, HighlightStyles highlightStyle, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            return Button(ButtonTypes.Button, buttonID, buttonText, size, highlightStyle, null, TextIconLayout.TextOnly, buttonHtmlAttributes, outerSpanHtmlAttributes);
        }

        /// <summary>
        /// 输出普通按钮
        /// </summary>
        public string Button(string buttonID, string buttonText, ButtonSizes size, HighlightStyles highlightStyle, IconTypes? iconType, TextIconLayout textIconLayout, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            return Button(ButtonTypes.Button, buttonID, buttonText, size, highlightStyle, iconType, textIconLayout, buttonHtmlAttributes, outerSpanHtmlAttributes);
        }

        /// <summary>
        /// 输出链接按钮
        /// 仅显示图标
        /// </summary>
        public string LinkButton(string buttonID, string href, HighlightStyles highlightStyle, IconTypes iconType)
        {
            return Button(ButtonTypes.Link, buttonID, string.Empty, ButtonSizes.Default, highlightStyle, iconType, TextIconLayout.IconOnly, new RouteValueDictionary { { "href", href } }, null);
        }
        /// <summary>
        /// 输出链接按钮
        /// 仅显示图标
        /// </summary>
        public string LinkButton(string buttonID, string href, HighlightStyles highlightStyle, IconTypes iconType, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            return Button(ButtonTypes.Link, buttonID, string.Empty, ButtonSizes.Default, highlightStyle, iconType, TextIconLayout.IconOnly, new RouteValueDictionary(buttonHtmlAttributes) { { "href", href } }, null);
        }

        /// <summary>
        /// 输出链接按钮
        /// 仅显示图标
        /// </summary>
        public string LinkButton(string buttonID, HighlightStyles highlightStyle, IconTypes iconType, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            return Button(ButtonTypes.Link, buttonID, string.Empty, ButtonSizes.Default, highlightStyle, iconType, TextIconLayout.IconOnly, buttonHtmlAttributes, outerSpanHtmlAttributes);
        }
        /// <summary>
        /// 输出链接按钮
        /// 仅显示文字
        /// </summary>
        public string LinkButton(string buttonID, string buttonText, string href, ButtonSizes size, HighlightStyles highlightStyle)
        {
            return Button(ButtonTypes.Link, buttonID, buttonText, size, highlightStyle, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "href", href } }, null);
        }
        /// <summary>
        /// 输出链接按钮
        /// 仅显示文字
        /// </summary>
        public string LinkButton(string buttonID, string buttonText, ButtonSizes size, HighlightStyles highlightStyle, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            return Button(ButtonTypes.Link, buttonID, buttonText, size, highlightStyle, null, TextIconLayout.TextOnly, buttonHtmlAttributes, outerSpanHtmlAttributes);
        }

        /// <summary>
        /// 输出链接按钮
        /// </summary>
        public string LinkButton(string buttonID, string buttonText, string href, ButtonSizes size, HighlightStyles highlightStyle, IconTypes? iconType, TextIconLayout TextIconLayout)
        {
            return Button(ButtonTypes.Link, buttonID, buttonText, size, highlightStyle, iconType, TextIconLayout, new RouteValueDictionary { { "href", href } }, null);
        }

        /// <summary>
        /// 输出链接按钮
        /// </summary>
        public string LinkButton(string buttonID, string buttonText, string href, ButtonSizes size, HighlightStyles highlightStyle, IconTypes? iconType, TextIconLayout TextIconLayout, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            return Button(ButtonTypes.Link, buttonID, buttonText, size, highlightStyle, iconType, TextIconLayout, new RouteValueDictionary(buttonHtmlAttributes ?? new RouteValueDictionary()) { { "href", href } }, outerSpanHtmlAttributes);
        }

        /// <summary>
        /// 输出提交按钮
        /// </summary>
        /// <param name="buttonID">提交按钮name、id属性值</param>
        /// <param name="buttonText">显示文字</param>
        public string SubmitButton(string buttonID, string buttonText)
        {
            return SubmitButton(buttonID, buttonText, ButtonSizes.Large, null, null);
        }

        /// <summary>
        /// 输出提交按钮
        /// </summary>
        /// <param name="buttonID">提交按钮name、id属性值</param>
        /// <param name="buttonText">显示文字</param>
        public string SubmitButton(string buttonID, string buttonText, ButtonSizes size, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            return Button(ButtonTypes.Submit, buttonID, buttonText, size, HighlightStyles.Primary, null, TextIconLayout.TextOnly, buttonHtmlAttributes, outerSpanHtmlAttributes);
        }

        /// <summary>
        /// 输出取消按钮
        /// <param name="href">取消按钮的链接地址</param>
        /// </summary>
        public string CancelButton(string url)
        {
            return CancelButton(ButtonSizes.Large, url);
        }

        /// <summary>
        /// 输出取消按钮
        /// </summary>
        public string CancelButton(RouteValueDictionary buttonHtmlAttributes)
        {
            return Button(string.Empty, ResourceManager.GetString("Button_Cancel", Globals.GetCurrentUserLanguage()), ButtonSizes.Default, HighlightStyles.Secondary, null, TextIconLayout.TextOnly, buttonHtmlAttributes, null);
        }

        /// <summary>
        /// 输出取消按钮
        /// </summary>
        /// <param name="buttonID">取消按钮name属性</param>
        /// <param name="size">按钮大小</param>
        /// <param name="buttonHtmlAttributes">其他html属性</param>
        public string CancelButton(ButtonSizes size, RouteValueDictionary buttonHtmlAttributes)
        {
            return Button(ButtonTypes.Button, string.Empty, ResourceManager.GetString("Button_Cancel", Globals.GetCurrentUserLanguage()), size, HighlightStyles.Secondary, null, TextIconLayout.TextOnly, buttonHtmlAttributes, null);
        }


        /// <summary>
        /// 输出按钮
        /// <param name="url">按钮的链接地址</param>
        /// </summary>
        public string Button(string text, string url)
        {
            return Button(text, url, ButtonSizes.Large, HighlightStyles.Secondary);
        }

        /// <summary>
        /// 输出按钮
        /// <param name="url">按钮的链接地址</param>
        /// </summary>
        public string Button(string text, string url, ButtonSizes size, HighlightStyles style)
        {
            return Button(ButtonTypes.Button, string.Empty, text, size, style, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "onclick", "window.location.href='" + url + "'" } }, null);
        }

        /// <summary>
        /// 输出关闭按钮
        /// <param name="href">取消按钮的链接地址</param>
        /// </summary>
        public string CloseButton(string url)
        {
            return CancelButton(ButtonSizes.Large, url);
        }

        /// <summary>
        /// 输出关闭按钮
        /// </summary>
        public string CloseButton(RouteValueDictionary buttonHtmlAttributes)
        {
            return Button(string.Empty, ResourceManager.GetString("Button_Close", Globals.GetCurrentUserLanguage()), ButtonSizes.Default, HighlightStyles.Secondary, null, TextIconLayout.TextOnly, buttonHtmlAttributes, null);
        }

        /// <summary>
        /// 输出关闭按钮
        /// </summary>
        /// <param name="buttonID">取消按钮name属性</param>
        /// <param name="size">按钮大小</param>
        /// <param name="buttonHtmlAttributes">其他html属性</param>
        public string CloseButton(ButtonSizes size, RouteValueDictionary buttonHtmlAttributes)
        {
            return Button(ButtonTypes.Button, string.Empty, ResourceManager.GetString("Button_Close", Globals.GetCurrentUserLanguage()), size, HighlightStyles.Secondary, null, TextIconLayout.TextOnly, buttonHtmlAttributes, null);
        }


        /// <summary>
        /// 输出取消按钮
        /// </summary>
        /// <param name="buttonID">取消按钮name属性</param>
        /// <param name="size">按钮大小</param>
        /// <param name="buttonHtmlAttributes">其他html属性</param>
        public string CancelButton(ButtonSizes size, string url)
        {
            return Button(ButtonTypes.Button, string.Empty, ResourceManager.GetString("Button_Cancel", Globals.GetCurrentUserLanguage()), size, HighlightStyles.Secondary, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "onclick", "window.location.href='" + url + "'" } }, null);
        }

        /// <summary>
        /// 输出重置表单按钮
        /// </summary>
        public string ResetButton()
        {
            return ResetButton(string.Empty, ResourceManager.GetString("Button_Reset", Globals.GetCurrentUserLanguage()), ButtonSizes.Large, HighlightStyles.Secondary, null, null);
        }

        /// <summary>
        /// 输出重置表单按钮
        /// </summary>
        public string ResetButton(string buttonID, string buttonText, ButtonSizes size, HighlightStyles highlightStyle, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            return Button(ButtonTypes.Reset, buttonID, buttonText, size, highlightStyle, null, TextIconLayout.TextOnly, buttonHtmlAttributes, outerSpanHtmlAttributes);
        }

        /// <summary>
        /// 输出操作按钮
        /// </summary>        
        public string ActionLink(string buttonText, string href)
        {
            return ActionLink(string.Empty, buttonText, href, null, TextIconLayout.TextOnly, null, null);
        }
        /// <summary>
        /// 输出操作按钮
        /// </summary>        
        public string ActionLink(string buttonID, string buttonText, string href, IconTypes? iconType)
        {
            return ActionLink(buttonID, buttonText, href, iconType, TextIconLayout.IconText, null, null);
        }
        /// <summary>
        /// 输出操作按钮
        /// </summary>        
        public string ActionLink(string buttonID, string buttonText, string href, IconTypes? iconType, TextIconLayout textIconLayout, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            TagBuilder span = new TagBuilder("span");
            TagBuilder a = new TagBuilder("a");
            string icon = string.Empty;

            if (!string.IsNullOrEmpty(buttonID))
            {
                a.MergeAttribute("id", buttonID);
                a.MergeAttribute("name", buttonID);
            }
            if (!string.IsNullOrEmpty(buttonText))
                a.InnerHtml = buttonText;
            if (!string.IsNullOrEmpty(href))
                a.MergeAttribute("href", href);
            span.AddCssClass("tn-action");
            a.AddCssClass("tn-action-text");
            if (buttonHtmlAttributes != null)
            {
                if (buttonHtmlAttributes.Any(n => n.Key.ToLower() == "class"))
                    a.AddCssClass(buttonHtmlAttributes.Single(n => n.Key.ToLower() == "class").Value.ToString());
            }
            a.MergeAttributes(buttonHtmlAttributes);

            if (outerSpanHtmlAttributes != null)
            {
                if (outerSpanHtmlAttributes.Any(n => n.Key.ToLower() == "class"))
                    span.AddCssClass(outerSpanHtmlAttributes.Single(n => n.Key.ToLower() == "class").Value.ToString());
            }
            span.MergeAttributes(outerSpanHtmlAttributes);
            if (iconType != null)
                icon = Icon(iconType.Value);

            switch (textIconLayout)
            {
                case TextIconLayout.IconText:
                    span.AddCssClass("tn-action-text-icon");
                    span.InnerHtml = icon + a.ToString();
                    break;
                case TextIconLayout.TextIcon:
                    span.AddCssClass("tn-action-text-icon-right");
                    span.InnerHtml = icon + a.ToString();
                    break;
                case TextIconLayout.MenuButton:
                    span.AddCssClass(" tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl");
                    span.InnerHtml = icon + a.ToString();
                    break;

                default:
                    span.InnerHtml = a.ToString();
                    break;
            }

            return span.ToString();
        }

        /// <summary>
        /// 输出按钮
        /// </summary>
        private string Button(ButtonTypes buttonType, string buttonID, string buttonText, ButtonSizes size, HighlightStyles highlightStyle, IconTypes? iconType, TextIconLayout textIconLayout, RouteValueDictionary buttonHtmlAttributes, RouteValueDictionary outerSpanHtmlAttributes)
        {
            TagBuilder span1 = new TagBuilder("span");
            TagBuilder span2 = new TagBuilder("span");
            TagBuilder button = null;
            if (buttonType == ButtonTypes.Link || buttonType == ButtonTypes.Action)
                button = new TagBuilder("a");
            else
                button = new TagBuilder("button");
            string icon = string.Empty;

            if (buttonType == ButtonTypes.Action)
            {
                span1.AddCssClass("tn-action");
            }
            span1.AddCssClass("tn-button");
            span2.AddCssClass("tn-first-child");

            if (!string.IsNullOrEmpty(buttonID))
                button.MergeAttribute("id", buttonID);

            button.AddCssClass("tn-button-text");
            if (!string.IsNullOrEmpty(buttonText))
                button.InnerHtml = buttonText;
            if (iconType != null)
                icon = Icon(iconType.Value);

            if (buttonHtmlAttributes != null)
            {
                if (buttonHtmlAttributes.Any(n => n.Key.ToLower() == "class"))
                    button.AddCssClass(buttonHtmlAttributes.Single(n => n.Key.ToLower() == "class").Value.ToString());
            }

            if (outerSpanHtmlAttributes != null)
            {
                if (outerSpanHtmlAttributes.Any(n => n.Key.ToLower() == "class"))
                    span1.AddCssClass(outerSpanHtmlAttributes.Single(n => n.Key.ToLower() == "class").Value.ToString());
            }
            span1.MergeAttributes(outerSpanHtmlAttributes);


            //设置按钮大小
            switch (size)
            {
                case ButtonSizes.Default:
                    break;
                case ButtonSizes.Large:
                    span1.AddCssClass("tn-button-large");
                    break;
                default:
                    break;
            }

            //设置按钮高亮类型
            switch (highlightStyle)
            {
                case HighlightStyles.Primary:
                    span1.AddCssClass("tn-button-primary");
                    break;
                case HighlightStyles.Secondary:
                    span1.AddCssClass("tn-button-secondary");
                    break;
                case HighlightStyles.Lite:
                    span1.AddCssClass("tn-button-lite");
                    break;
                case HighlightStyles.Default:
                default:
                    span1.AddCssClass("tn-button-default");
                    break;
            }

            switch (buttonType)
            {
                case ButtonTypes.Submit:

                    string changeButtonTextScript = "if($(this).parents('form:first').valid()) {$(this).hide().next('button:last').show();}";
                    if (buttonHtmlAttributes != null && buttonHtmlAttributes.Any(n => n.Key.ToLower() == "onclick"))
                    {
                        string clickhandler = buttonHtmlAttributes.Single(n => n.Key.ToLower() == "onclick").Value.ToString();
                        clickhandler += changeButtonTextScript;
                        button.MergeAttribute("onclick", clickhandler);
                    }
                    else
                        button.MergeAttribute("onclick", changeButtonTextScript);

                    button.MergeAttribute("type", "submit");
                    break;
                case ButtonTypes.Reset:
                    button.MergeAttribute("type", "reset");
                    break;
                case ButtonTypes.Link:
                    if (buttonHtmlAttributes != null)
                    {
                        if (buttonHtmlAttributes.Any(n => n.Key.ToLower() == "href"))
                            button.MergeAttribute("href", buttonHtmlAttributes.Single(n => n.Key.ToLower() == "href").Value.ToString());
                        if (buttonHtmlAttributes.Any(n => n.Key.ToLower() == "onclick"))
                            button.MergeAttribute("onclick", buttonHtmlAttributes.Single(n => n.Key.ToLower() == "onclick").Value.ToString());
                    }
                    button.MergeAttribute("href", "javascript:;", false);
                    break;
                case ButtonTypes.Button:
                default:
                    button.MergeAttribute("type", "button");
                    break;
            }
            button.MergeAttributes(buttonHtmlAttributes);
            switch (textIconLayout)
            {
                case TextIconLayout.IconText:
                    span1.AddCssClass("tn-button-text-icon");
                    span2.InnerHtml = icon + button.ToString();
                    break;
                //case TextIconLayout.TextIcon:
                //    span1.AddCssClass("tn-button-text-icon-right");
                //    span2.InnerHtml = button.ToString() + icon;
                //    break;
                case TextIconLayout.MenuButton:
                    span1.AddCssClass("tn-menu-button tn-button-text-icon");

                    span2.InnerHtml = "<span class=\"tn-icon tn-icon-triangle-down\"></span>" + button.ToString();
                    break;
                case TextIconLayout.IconOnly:
                    span1.AddCssClass("tn-button-icon");
                    button.InnerHtml = icon;
                    span2.InnerHtml = button.ToString();
                    break;
                case TextIconLayout.TextOnly:
                default:
                    span2.InnerHtml = button.ToString();
                    break;
            }
            if (buttonType == ButtonTypes.Submit)
            {
                TagBuilder buttonHide = new TagBuilder("button");
                buttonHide.MergeAttribute("id", buttonID + "_ForHide");
                buttonHide.MergeAttribute("type", "button");
                buttonHide.MergeAttribute("style", "display:none;");
                buttonHide.InnerHtml = ResourceManager.GetString("Message_Loading", Globals.GetCurrentUserLanguage());
                buttonHide.MergeAttributes(button.Attributes);
                buttonHide.MergeAttribute("onclick", string.Empty, true);
                span2.InnerHtml += buttonHide.ToString();
            }
            span1.InnerHtml += span2.ToString();
            return span1.ToString();
        }

        /// <summary>
        /// 按钮类型
        /// </summary>
        private enum ButtonTypes
        {
            // 输入按钮
            Button,
            //提交按钮
            Submit,
            ///重置按钮
            Reset,
            //链接
            Link,
            //操作链接
            Action
        }
    }

    /// <summary>
    /// 超级链接Target
    /// </summary>
    public enum HyperLinkTarget
    {
        /// <summary>
        /// 将内容呈现在一个没有框架的新窗口中
        /// </summary>
        _blank,

        /// <summary>
        /// 将内容呈现在含焦点的框架中
        /// </summary>
        _self,

        /// <summary>
        /// 将内容呈现在上一个框架集父级中
        /// </summary>
        _parent,

        /// <summary>
        /// 将内容呈现在没有框架的全窗口中
        /// </summary>
        _top

    }

    /// <summary>
    /// 图标类型
    /// </summary>
    public enum IconTypes
    {

        TriangleUp,//上箭头
        TriangleRight,//右箭头
        TriangleDown,//下
        TriangleLeft,//左


        CollapseOpen,//展开
        CollapseClose,//收起

        Download,//下载
        Upload,// 上传

        Add,//添加、新建
        Write,//编辑、描述
        Update,//更新、重建
        Cross,//删除、关闭
        Accept,//通过、允许、同意
        Stop,//不通过、否定、拒绝、阻止
        Set,//设置
        Config,//配置



        Elite,//精华
        Email,//消息，未读
        EmailOpen,//消息，已读
        Top,//置顶
        Flag,//推荐
        Lock,//锁定、私有
        Key,//密钥访问
        Limit,//权限访问


        View,//浏览、查看
        ThumbUp,//支持、顶
        ThumbDown,//反对、踩
        Share,//分享
        Bubble,//评论、留言
        Favorite,//收藏、喜爱 
        Star,//加星
        Feed,//订阅


        User,// 用户、好友、成员
        UserAdd,//添加好友
        UserAllow,//特许用户
        UserStop,//阻止用户
        UserRelation,// 用户关系
        UserAvatar,//用户头像
        UserInvite, //邀请用户
        UserCard,//用户卡片

        BrowseList,//列表浏览
        BrowseDetail,//详情浏览
        BrowseMedium,//中图、中块浏览
        BrowseSmall,//小图、小块浏览
        BrowseSlide,//幻灯浏览
        Dress,//页面装扮，布局调整
        Jump,//跳转
        Zomm,//放大
        Camera,//照片
        Movie,//视频
        Sound,//声音
        Music,//音乐
        World,//互联网


        Alert,// 警告 
        Exclamation,//提示
        CrossCircle,//错误
        AcceptCircle,//正确
        Apply,// 申请 
        Logout,//注销
        Join,//  加入
        Quit,//退出                
        Emotion, //表情
        PaperClip,//附件
        UserGroup,//群组
        Event,//活动
        Find,//搜索
        Picture,//图片
        Archive,
        Question,//疑问
        Coins,//货币

        Topic,//主题
        Fire,//热点主题
        QuotesBefore,//引用
        Color,//颜色
        App,//应用

        Play,//播放

        Pause //暂停
    }

    /// <summary>
    /// 按钮大小
    /// </summary>
    public enum ButtonSizes
    {
        /// <summary>
        /// 默认大小
        /// </summary>
        Default,
        /// <summary>
        /// 大按钮
        /// </summary>
        Large
    }

    /// <summary>
    /// 文本和图标的布局方式
    /// </summary>
    public enum TextIconLayout
    {
        /// <summary>
        /// 仅显示文本
        /// </summary>
        TextOnly,
        /// <summary>
        /// 图标在前，文本在后
        /// </summary>
        IconText,
        /// <summary>
        /// 文本在前，图标在后
        /// </summary>
        TextIcon,
        /// <summary>
        /// 带下拉按钮的布局
        /// </summary>
        MenuButton,
        /// <summary>
        /// 仅显示图标
        /// </summary>
        IconOnly
    }

    /// <summary>
    /// 高亮显示类型
    /// </summary>
    public enum HighlightStyles
    {
        /// <summary>
        /// 默认高亮
        /// 淡蓝色
        /// </summary>
        Default,
        /// <summary>
        /// 主流高亮
        /// 深蓝色，主要用于提交等需要突出显示的按钮
        /// </summary>
        Primary,
        /// <summary>
        /// 非主流高亮
        /// 灰色，主要用于取消等不需要突出显示的按钮
        /// </summary>
        Secondary,
        /// <summary>
        /// 最弱的高亮效果
        /// 不显示背景色，只有鼠标移上去才会显示背景色
        /// </summary>
        Lite
    }
}