﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 超级链接实体类
    /// </summary>
    public class HyperLinkEntity
    {
        public HyperLinkEntity(string text, string navigateUrl, bool urlTargetBlank, string toolTips)
        {
            this.text = text;
            this.navigateUrl = navigateUrl;
            this.urlTargetBlank = urlTargetBlank;
            this.toolTips = toolTips;
        }

        private string text;
        /// <summary>
        /// Text
        /// </summary>
        public string Text
        {
            get { return text; }
            set { text = value; }
        }

        private string navigateUrl = string.Empty;
        /// <summary>
        /// 导航地址
        /// </summary>
        public string NavigateUrl
        {
            get { return navigateUrl; }
            set { navigateUrl = value; }
        }

        private bool urlTargetBlank = false;
        /// <summary>
        /// 是否在新窗口打开链接
        /// </summary>
        public bool UrlTargetBlank
        {
            get { return urlTargetBlank; }
            set { urlTargetBlank = value; }
        }

        private string toolTips = string.Empty;
        /// <summary>
        /// 提示信息
        /// </summary>
        public string ToolTips
        {
            get { return toolTips; }
            set { toolTips = value; }
        }
    }
}
