﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 生成 &lt;script src="a.js" type="text/javascript"&gt;&lt;/script&gt; (可以设置浏览器缓存过期时间)
    /// </summary>    
    [ToolboxData("<{0}:Script runat=\"server\" />")]
    public class Script : Control
    {
        private string src = "~/Utility/tunynet_web_ui/global.js";
        public virtual String Src
        {
            get { return src; }
            set { src = value; }
        }

        private bool enableHttpCompress = false;
        /// <summary>
        /// 是否启用Http压缩
        /// </summary>
        /// <remarks>
        /// 启用压缩时某些JavaScript有为题
        /// </remarks>
        public bool EnableHttpCompress
        {
            get { return enableHttpCompress; }
            //set { enableHttpCompress = value; }
        }

        private int setExpireDays = 0;
        /// <summary>
        /// 客户端浏览器缓存过期时间(天数)
        /// </summary>
        /// <remarks>
        /// 设置 Response.Cache.SetExpires()
        /// 对于asp.net ajax、JQuery 等框架很少变动的文件建议设置 缓存过期时间
        /// </remarks>
        public int SetExpireDays
        {
            get { return setExpireDays; }
            set { setExpireDays = value; }
        }

        private bool forceLoad = false;
        /// <summary>
        /// 设置是否强制加载js文件（本属性仅用于弹出模式窗口）
        /// 如果需要强制加载则在js链接中添加属性:rel="forceLoad"
        /// </summary>
        public bool ForceLoad
        {
            get { return forceLoad; }
            set { forceLoad = value; }
        }

        const string scriptFormat = "<script src=\"{0}\" {1} type=\"text/javascript\"></script>";
        const string scriptCompressFormat = "<script src=\"{0}.compress.axd{1}\" charset=\"GBK\" {2} type=\"text/javascript\"></script>";

        protected override void Render(HtmlTextWriter writer)
        {
            // 设置强制加载js文件的属性字符串
            string forceLoadString = string.Empty;
            if (ForceLoad)
                forceLoadString = "rel=\"forceLoad\"";
            if (Src.StartsWith("http"))
                writer.Write(scriptFormat, Src);
            else
            {
                string jsSrc = Globals.GetFullUrlInResourceSite(Src);

                if (EnableHttpCompress)
                {
                    string[] fileParts = jsSrc.Split('?');

                    string queryString = string.Empty;
                    if (fileParts.Length > 1)
                        queryString = "?" + fileParts[1];

                    if (SetExpireDays > 0)
                    {
                        if (queryString.Length > 0)
                            queryString = "&SetExpireDays=" + SetExpireDays;
                        else
                            queryString = "?SetExpireDays=" + SetExpireDays;
                    }

                    writer.Write(scriptCompressFormat, fileParts[0], queryString, forceLoadString);

                }
                else
                {
                    writer.Write(scriptFormat, jsSrc, forceLoadString);
                }
            }
        }

    }
}