﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI;
using System.IO;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 样式表控件
    /// </summary>
    ///<remarks>
    /// 主要功能如下：
    /// <list type="bullet">
    ///     <item>
    ///         <description>可设置<see cref="Enqueue"/>属性，控制是否把css文件直接加载还是放入队列以后加载;</description>
    ///     </item>
    ///     <item>
    ///         <description>可用于加载单个css文件<seealso cref="SpaceBuilder.Web.UI.Style.Href"/>;</description>
    ///     </item>
    ///     <item>
    ///         <description>可用于加载某个文件夹下所有css文件<seealso cref="SpaceBuilder.Web.UI.Style.HrefDir"/></description>
    ///     </item>
    /// </list>
    ///</remarks>
    [ToolboxData("<{0}:Style runat=\"server\" />")]
    public class Style : Control
    {
        /// <summary>
        /// 映射到html中的&lt;link media="" /&gt;
        /// </summary>
        private string media = "screen";
        public String Media
        {
            get { return media; }
            set { media = value; }
        }


        private string href;
        /// <summary>
        /// css文件的href属性（可以是完整的url或相对的路径）
        /// </summary>
        public virtual String Href
        {
            get
            {
                if (href != null)
                {
                    if (href.StartsWith("/") || href.StartsWith(".") || href.StartsWith("~/"))
                        return Globals.GetFullUrlInResourceSite(href);
                }
                return string.Empty;
            }
            set { href = value; }
        }

        private int setExpireDays = 0;
        /// <summary>
        /// 客户端浏览器缓存过期时间(天数)
        /// </summary>
        /// <remarks>
        /// 设置 Response.Cache.SetExpires()
        /// 对于asp.net ajax、JQuery 等框架很少变动的文件建议设置 缓存过期时间
        /// </remarks>
        public int SetExpireDays
        {
            get { return setExpireDays; }
            set { setExpireDays = value; }
        }

        /// <summary>
        /// html中css文件的链接代码
        /// </summary>
        const string linkFormat = "<link rel=\"stylesheet\" href=\"{0}\" type=\"text/css\" media=\"{1}\" />";
        const string linkCompressFormat = "<link rel=\"stylesheet\" href=\"{0}.compress.axd{1}\" type=\"text/css\" media=\"{2}\" />";

        /// <summary>
        /// 在Render生命周期中对需要呈现的css文件进行处理
        /// </summary>
        protected override void Render(HtmlTextWriter writer)
        {
            if (!string.IsNullOrEmpty(Href))
            {
                if (EnableHttpCompress)
                {
                    string[] fileParts = Href.Split('?');

                    string queryString = string.Empty;
                    if (fileParts.Length > 1)
                        queryString = "?" + fileParts[1];

                    if (SetExpireDays > 0)
                    {
                        if (queryString.Length > 0)
                            queryString = "&SetExpireDays=" + SetExpireDays;
                        else
                            queryString = "?SetExpireDays=" + SetExpireDays;
                    }

                    writer.Write(linkCompressFormat, fileParts[0], queryString, Media);
                }
                else
                {
                    writer.Write(linkFormat, Href, Media);
                }
            }
        }

        private bool enableHttpCompress = false;
        /// <summary>
        /// 是否启用Http压缩
        /// </summary>
        public bool EnableHttpCompress
        {
            get { return enableHttpCompress; }
            //set { enableHttpCompress = value; }
        }

    }
}