﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// The StyleRelativePosition enumeration is used when rendering  the WL:Head control.  
    /// Render First items are rendered in the order they were programmatically added,
    /// then Unspecified, and finally Last items.
    /// </summary>
    public enum StyleRelativePosition
    {
        /// <summary>
        /// rendered before unspecified and last items
        /// </summary>
        First = 1,

        /// <summary>
        /// rendered after first and unspecified items
        /// </summary>
        Last = 2,

        /// <summary>
        /// The default render location..  renderes between first and last items
        /// </summary>
        Unspecified = 3
    }
}
