﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Web;
using System.Web.Mvc;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{

    public class ChannelPresentAreaThemeManager : PresentAreaThemeManager
    {
        #region Instance
        private static volatile ChannelPresentAreaThemeManager _instance = new ChannelPresentAreaThemeManager();
        public static ChannelPresentAreaThemeManager Instance()
        {
            return _instance;
        }

        private ChannelPresentAreaThemeManager()
        { }
        #endregion

        /// <summary>
        /// 获取当前表现区域所选中的皮肤名称
        /// </summary>
        public override string GetSelectedThemeName(ControllerContext controllerContext)
        {
            string themeName = SiteSettingsManager.GetSiteSettings().SiteTheme;

            if (string.IsNullOrEmpty(themeName))
                themeName = PresentArea.DefaultTheme;

            return themeName;
        }

        /// <summary>
        /// 获取当前表现区域所选中的外观名称
        /// </summary>
        public override string GetSelectedThemeAppearanceName(ControllerContext controllerContext)
        {
            string themeAppearanceName = SiteSettingsManager.GetSiteSettingsForAdmin().SiteThemeAppearance;
            if (string.IsNullOrEmpty(themeAppearanceName))
                themeAppearanceName = PresentArea.DefaultAppearance;

            return themeAppearanceName;
        }

        /// <summary>
        /// 保存选中的皮肤名和外观名
        /// </summary>
        public override void SavaThemeAndAppearance(ControllerContext controllerContext, string themeName, string themeAppearanceName)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettingsForAdmin();
            siteSettings.SiteTheme = themeName;
            siteSettings.SiteThemeAppearance = themeAppearanceName;
            SiteSettingsManager.Save(siteSettings);
        }

        /// <summary>
        /// 表现区域ID
        /// </summary>
        public override int PresentAreaID
        {
            get { return PresentAreaIDs.Instance().Channel(); }
        }

        /// <summary>
        /// 验证用户是否对拥有者空间具有管理权限
        /// </summary>
        /// <param name="ownerID">拥有者ID</param>
        /// <param name="User">用户</param>
        public override bool HasThemeManagerPermission(int ownerID, User user)
        {
            if (user == null)
                return false;
            //管理员
            if (user.IsAdministrator || user.IsContentAdministrator)
                return true;
            return false;
        }
        private IList<string> layoutModes = null;
        /// <summary>
        /// 版式集合
        /// </summary>
        public override IList<string> LayoutModes
        {
            get
            {
                if (layoutModes == null)
                    layoutModes = new List<string> { "12", "21", "111", "332", "233", "453", "354" };

                return layoutModes;
            }
        }
    }
}