﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.Web
{
    /// <summary>
    /// 可以公开显示的Channel页面基类
    /// </summary>
    public class ChannelPublicViewPage : SPBViewPage
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return ChannelPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                if (!Request.RawUrl.Contains(SiteUrls.Instance().SitePause()) && !SiteUrls.Instance().SitePause().Contains(Request.RawUrl))
                {
                    Response.Redirect(SiteUrls.Instance().SitePause(), true);
                    return;
                }
            }

            base.OnLoad(e);

        }
    }


    /// <summary>
    /// 频道ViewPage泛型基类
    /// </summary>
    public class ChannelPublicViewPage<TModel> : SPBViewPage<TModel> where TModel : class
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return ChannelPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                if (!Request.RawUrl.Contains(SiteUrls.Instance().SitePause()) && !SiteUrls.Instance().SitePause().Contains(Request.RawUrl))
                {
                    Response.Redirect(SiteUrls.Instance().SitePause(), true);
                    return;
                }
            }

            base.OnLoad(e);
        }
    }


}
