﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Club;
using SpaceBuilder.Common;
using System.Web.Routing;
using SpaceBuilder.Forum;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 群组ViewPage基类
    /// </summary>
    public class ClubDomainViewPage : SPBViewPage
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return ClubPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }
            else if (!siteSettings.EnableAnonymousBrowse && !Request.IsAuthenticated)
            {
                Response.Redirect(SiteUrls.Instance().Login(true), true);
                return;
            }

            string clubDomainName = ViewContext.GetParameterFromRouteDateOrQueryString("clubDomainName");
            SpaceBuilder.Club.Club currentDomainClub = Clubs.GetClub(clubDomainName, false);
            if (currentDomainClub != null)
            {
                #region 群组转换为论坛后直接跳到论坛板块组

                ForumSectionGroup group = ForumSectionGroups.GetGroup(PresentAreaIDs.Instance().ClubDomain(), currentDomainClub.ClubID, false);
                if (group == null)
                {
                    Response.Redirect(SPBUrlHelper.Action("ShowForumGroup", "ChannelForum", new RouteValueDictionary { { "groupID", OwnerID2GroupIDDictionary.Instance(PresentAreaIDs.Instance().Channel()).GetGroupID(currentDomainClub.ClubID) } }));
                    Response.End();
                }

                #endregion

                User currentUser = Globals.GetCurrentUser();

                #region 未通过审核的群组禁止进入

                if (currentDomainClub.AuditingStatus == AuditingStatuses.Fail)
                {
                    if (currentUser == null || (!currentUser.IsContentAdministrator && !ClubMembers.HasClubManagerPermission(currentDomainClub.ClubID, currentUser)))
                        throw new SPBException(ExceptionTypes.Instance().AccessDenied(), string.Format("群组 {0} 还未通过审核", currentDomainClub.DomainName));
                }

                #endregion

                if (!currentDomainClub.IsEnabled && (currentUser == null || !currentUser.IsContentAdministrator))
                    Response.Redirect(SiteUrls.Instance().Error("群组已禁用不能访问"));
            }

            base.OnLoad(e);
        }
    }


    /// <summary>
    /// 群组ViewPage泛型基类
    /// </summary>
    public class ClubDomainViewPage<TModel> : SPBViewPage<TModel> where TModel : class
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return ClubPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }
            else if (!siteSettings.EnableAnonymousBrowse && !Request.IsAuthenticated)
            {
                Response.Redirect(SiteUrls.Instance().Login(true), true);
                return;
            }

            string clubDomainName = ViewContext.GetParameterFromRouteDateOrQueryString("clubDomainName");
            SpaceBuilder.Club.Club currentDomainClub = Clubs.GetClub(clubDomainName, false);
            if (currentDomainClub != null)
            {
                #region 群组转换为论坛后直接跳到论坛板块组

                ForumSectionGroup group = ForumSectionGroups.GetGroup(PresentAreaIDs.Instance().ClubDomain(), currentDomainClub.ClubID, false);
                if (group == null)
                {
                    
                    Response.Redirect(SPBUrlHelper.Action("ShowForumGroup", "ChannelForum", new RouteValueDictionary { { "groupID", OwnerID2GroupIDDictionary.Instance(PresentAreaIDs.Instance().Channel()).GetGroupID(currentDomainClub.ClubID) } }));
                    Response.End();
                }

                #endregion

                User currentUser = Globals.GetCurrentUser();

                #region 未通过审核的群组禁止进入

                if (currentDomainClub.AuditingStatus == AuditingStatuses.Fail)
                {
                    if (!currentUser.IsContentAdministrator && !ClubMembers.HasClubManagerPermission(currentDomainClub.ClubID, currentUser))
                        throw new SPBException(ExceptionTypes.Instance().AccessDenied(), string.Format("群组 {0} 还未通过审核", currentDomainClub.DomainName));
                }

                #endregion

                if (!currentDomainClub.IsEnabled && (currentUser == null || !currentUser.IsContentAdministrator))
                    Response.Redirect(SiteUrls.Instance().Error("群组已禁用不能访问"));
            }

            base.OnLoad(e);
        }
    }


}