﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Web;
using System.Web.Mvc;
using SpaceBuilder.Club;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{

    public class ClubPresentAreaThemeManager : PresentAreaThemeManager
    {
        #region Instance
        private static volatile ClubPresentAreaThemeManager _instance = new ClubPresentAreaThemeManager();
        public static ClubPresentAreaThemeManager Instance()
        {
            return _instance;
        }

        private ClubPresentAreaThemeManager()
        { }
        #endregion

        /// <summary>
        /// 表现区域ID
        /// </summary>
        public override int PresentAreaID
        {
            get { return PresentAreaIDs.Instance().ClubDomain(); }
        }

        /// <summary>
        /// 获取当前表现区域所选中的皮肤名称
        /// </summary>
        public override string GetSelectedThemeName(ControllerContext controllerContext)
        {
            string clubDomainName = controllerContext.GetParameterFromRouteDateOrQueryString("clubDomainName");
            string themeName = null;

            if (PresentArea.EnableThemes)
            {
                SpaceBuilder.Club.Club currentDomainClub = Clubs.GetClub(clubDomainName, false);
                Theme selectedTheme = Themes.GetTheme(PresentAreaID, currentDomainClub.Theme, true, true);
                if (selectedTheme != null)
                {
                    bool isRealTime = ClubPermission.Validate(currentDomainClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditClub());
                    currentDomainClub = Clubs.GetClub(currentDomainClub.ClubID, isRealTime);
                    if (currentDomainClub != null)
                    {
                        themeName = currentDomainClub.Theme;
                    }
                }
            }
            if (string.IsNullOrEmpty(themeName))
                themeName = PresentArea.DefaultTheme;

            return themeName;
        }

        /// <summary>
        /// 获取当前表现区域所选中的外观名称
        /// </summary>
        public override string GetSelectedThemeAppearanceName(ControllerContext controllerContext)
        {
            Club.Club currentClub = GetCurrentClub(controllerContext);
            string themeAppearanceName = null;
            bool isRealTime = ClubPermission.Validate(currentClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditClub());
            currentClub = Clubs.GetClub(currentClub.ClubID, isRealTime);
            if (currentClub != null)
            {
                if (!string.IsNullOrEmpty(currentClub.ThemeAppearance))
                {
                    ThemeAppearance themeAppearance = Themes.GetThemeAppearance(PresentAreaID, currentClub.Theme, currentClub.ThemeAppearance, true, true);
                    if (themeAppearance != null)
                        themeAppearanceName = currentClub.ThemeAppearance;
                }
            }

            if (themeAppearanceName != null)
                return themeAppearanceName;
            return PresentArea.DefaultAppearance;
        }

        /// <summary>
        /// 保存选中的皮肤名和外观名
        /// </summary>
        public override void SavaThemeAndAppearance(ControllerContext controllerContext, string themeName, string themeAppearanceName)
        {
            Club.Club currentClub = GetCurrentClub(controllerContext);

            currentClub.Theme = themeName;
            currentClub.ThemeAppearance = themeAppearanceName;
            Clubs.UpdateClub(currentClub);
        }

        /// <summary>
        /// 验证用户是否对拥有者空间具有管理权限
        /// </summary>
        /// <param name="ownerID">拥有者ID</param>
        /// <param name="User">用户</param>
        public override bool HasThemeManagerPermission(int ownerID, User user)
        {
            if (user == null)
                return false;
            //管理员
            if (user.IsAdministrator || user.IsContentAdministrator)
                return true;
            //圈子成员具备圈子管理权限
            if (ClubMembers.HasClubManagerPermission(ownerID, user))
                return true;
            return false;
        }

        private IList<string> layoutModes = null;
        /// <summary>
        /// 版式集合
        /// </summary>
        public override IList<string> LayoutModes
        {
            get
            {
                if (layoutModes == null)
                    layoutModes = new List<string> { "13", "31", "121" };

                return layoutModes;
            }
        }

        private SpaceBuilder.Club.Club GetCurrentClub(ControllerContext controllerContext)
        {
            string clubDomainName = controllerContext.GetParameterFromRouteDateOrQueryString("clubDomainName");
            SpaceBuilder.Club.Club currentDomainClub = Clubs.GetClub(clubDomainName, false);
            if (currentDomainClub == null)
            {
                throw new Exception(string.Format(ResourceManager.GetString("Exception_Pattern_ClubNotExist", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().Club()), clubDomainName));
            }
            return currentDomainClub;
        }
    }
}