﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using System.Web;
using SpaceBuilder.Web;
using System.Web.Mvc;
using System.Web.Routing;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 微博ViewPage基类
    /// </summary>
    public class MicroBlogDomainViewPage : SPBViewPage
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return MicroBlogPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {

                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }
            else if (!siteSettings.EnableAnonymousBrowse && !Request.IsAuthenticated)
            {
                Response.Redirect(SPBUrlHelper.Action("MicroBlogHome", "MicroBlog"), true);
                return;
            }

            base.OnLoad(e);


        }
    }


    /// <summary>
    /// 微博内ViewPage泛型基类
    /// </summary>
    public class MicroBlogDomainViewPage<TModel> : SPBViewPage<TModel> where TModel : class
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return MicroBlogPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }
            else if (!siteSettings.EnableAnonymousBrowse && !Request.IsAuthenticated)
            {
                Response.Redirect(SPBUrlHelper.Action("MicroBlogHome", "MicroBlog"), true);
                return;
            }

            base.OnLoad(e);
        }
    }
}