﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using System.Web.Mvc;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 表现区域皮肤管理类
    /// </summary>
    public abstract class PresentAreaThemeManager
    {
        /// <summary>
        /// 获取当前表现区域所选中的皮肤名称
        /// </summary>
        public abstract string GetSelectedThemeName(ControllerContext controllerContext);
        /// <summary>
        /// 获取当前表现区域所选中的外观名称
        /// </summary>
        public abstract string GetSelectedThemeAppearanceName(ControllerContext controllerContext);
        /// <summary>
        /// 保存选中的皮肤名和外观名
        /// </summary>
        public abstract void SavaThemeAndAppearance(ControllerContext controllerContext, string themeName, string themeAppearanceName);

        /// <summary>
        /// 验证用户是否对拥有者空间具有管理权限
        /// </summary>
        /// <param name="ownerID">拥有者ID</param>
        /// <param name="user">用户</param>
        public abstract bool HasThemeManagerPermission(int ownerID, User user);

        /// <summary>
        /// 版式集合
        /// </summary>
        public abstract IList<string> LayoutModes { get; }

        /// <summary>
        /// 表现区域
        /// </summary>
        public PresentArea PresentArea
        {
            get
            {
                PresentArea presentArea = PresentAreas.GetPresentArea(PresentAreaID, false);
                if (presentArea == null)
                    throw new ArgumentException("presentAreaID is not valide");
                return presentArea;
            }
        }
        /// <summary>
        /// 表现区域ID
        /// </summary>
        public abstract int PresentAreaID { get; }

    }
}
