﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Common;


namespace SpaceBuilder.Web
{
    /// <summary>
    /// ViewPage基类
    /// </summary>
    public abstract class SPBViewPage : ViewPage
    {

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            SpaceBuilder.Web.Header.AddStyle(SiteUrls.Instance().TN_CoreCss(), "screen", StyleRelativePosition.First);
            SpaceBuilder.Web.Header.AddStyle(SiteUrls.Instance().TN_ThemeCss(), "screen", StyleRelativePosition.First);
            SpaceBuilder.Web.Header.AddStyle(SiteUrls.Instance().TN_WidgetsCss(), "screen", StyleRelativePosition.First);
            SpaceBuilder.Web.Header.AddStyle(SiteUrls.Instance().CommonCss(), "screen", StyleRelativePosition.First);

            LoadThemeStyleSheets(ThemeManager.PresentArea.ThemeLocation, ThemeManager.GetSelectedThemeName(ViewContext), ThemeManager.GetSelectedThemeAppearanceName(ViewContext));
        }

        /// <summary>
        /// ThemeManager
        /// </summary>
        protected abstract PresentAreaThemeManager ThemeManager { get; }



        /// <summary>
        /// 加载皮肤的css文件
        /// </summary>
        /// <param name="themeLocation">主题所在路径</param>
        /// <param name="themeName">主题名称</param>
        /// <param name="themeAppearanceName">外观名称</param>
        /// <param name="defaultAppearanceName">默认外观名称</param>
        protected void LoadThemeStyleSheets(string themeLocation, string themeName, string themeAppearanceName)
        {
            Theme theme = Themes.GetTheme(ThemeManager.PresentAreaID, themeName, true, false);

            if (theme == null)
            {
                IList<Theme> themes = Themes.GetThemes(ThemeManager.PresentAreaID, true, false);
                if (themes == null)
                    throw new Exception(string.Format("{0}下没有任何主题", ThemeManager));
                theme = themes.First();
            }

            string commonCssPath = Globals.GetFullUrlInResourceSite(string.Format("{0}/{1}/common.css", themeLocation, theme.DirectoryName));
            SpaceBuilder.Web.Header.AddStyle(commonCssPath, "screen", StyleRelativePosition.Last);

            //是否使用默认Appearance
            bool useDefaultAppearance = false;

            if (string.IsNullOrEmpty(themeAppearanceName) || themeAppearanceName.Equals(theme.DefaultAppearanceName, StringComparison.InvariantCultureIgnoreCase))
                useDefaultAppearance = true;

            ThemeAppearance themeAppearance = null;
            if (useDefaultAppearance == false)
            {
                themeAppearance = Themes.GetThemeAppearance(ThemeManager.PresentAreaID, themeName, themeAppearanceName, true, false);
                if (themeAppearance == null)
                    useDefaultAppearance = true;
            }

            if (useDefaultAppearance == true)
            {
                string cssPath = Globals.GetFullUrlInResourceSite(string.Format("{0}{1}", themeLocation, theme.DefaultAppearance.CssFileNameWithPath));
                SpaceBuilder.Web.Header.AddStyle(cssPath, "screen", StyleRelativePosition.Last);
                SpaceBuilder.Web.Header.SetLogoUrl(theme.DefaultAppearance.LogoUrl);
            }
            else if (themeAppearance != null)
            {
                string appearanceCssPath = Globals.GetFullUrlInResourceSite(string.Format("{0}{1}", themeLocation, themeAppearance.CssFileNameWithPath));
                SpaceBuilder.Web.Header.AddStyle(appearanceCssPath, "screen", StyleRelativePosition.Last);
                SpaceBuilder.Web.Header.SetLogoUrl(themeAppearance.LogoUrl);
            }

            if (theme.EnablePrintCSS)
            {
                string printCssPath = Globals.GetFullUrlInResourceSite(string.Format("{0}{1}/appearances/{2}/print.css", themeLocation, themeName, theme.DefaultAppearanceName));
                SpaceBuilder.Web.Header.AddStyle(printCssPath, "print", StyleRelativePosition.Last);
            }
        }

        #region  属性
        private User currentUser = null;
        /// <summary>
        /// 当前用户
        /// </summary>
        protected User CurrentUser
        {
            get
            {
                if (currentUser == null)
                    currentUser = Globals.GetCurrentUser();

                return currentUser;
            }
        }
        private string currentUserLanguage = string.Empty;
        /// <summary>
        /// 当前用户的语言设置
        /// 如果是匿名用户，可能存放在Cookiee中
        /// </summary>
        protected string CurrentUserLanguage
        {
            get
            {
                if (string.IsNullOrEmpty(currentUserLanguage))
                    currentUserLanguage = Globals.GetCurrentUserLanguage();
                return currentUserLanguage;
            }
        }
        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage);
        }
        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <param name="applicationID">应用ID</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey, int applicationID)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage, applicationID);
        }

        #endregion
    }



    /// <summary>
    /// ViewPage泛型形式的基类
    /// </summary>
    public abstract class SPBViewPage<TModel> : ViewPage<TModel> where TModel : class
    {

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            SpaceBuilder.Web.Header.AddStyle(SiteUrls.Instance().TN_CoreCss(), "screen", StyleRelativePosition.First);
            SpaceBuilder.Web.Header.AddStyle(SiteUrls.Instance().TN_ThemeCss(), "screen", StyleRelativePosition.First);
            SpaceBuilder.Web.Header.AddStyle(SiteUrls.Instance().TN_WidgetsCss(), "screen", StyleRelativePosition.First);
            SpaceBuilder.Web.Header.AddStyle(SiteUrls.Instance().CommonCss(), "screen", StyleRelativePosition.First);

            LoadThemeStyleSheets(ThemeManager.PresentArea.ThemeLocation, ThemeManager.GetSelectedThemeName(ViewContext), ThemeManager.GetSelectedThemeAppearanceName(ViewContext));

        }

        /// <summary>
        /// ThemeManager
        /// </summary>
        protected abstract PresentAreaThemeManager ThemeManager { get; }


        /// <summary>
        /// 加载皮肤的css文件
        /// </summary>
        /// <param name="themeLocation">主题所在路径</param>
        /// <param name="themeName">主题名称</param>
        /// <param name="themeAppearanceName">外观名称</param>
        /// <param name="defaultAppearanceName">默认外观名称</param>
        protected void LoadThemeStyleSheets(string themeLocation, string themeName, string themeAppearanceName)
        {
            Theme theme = Themes.GetTheme(ThemeManager.PresentAreaID, themeName, true, false);

            if (theme == null)
            {
                IList<Theme> themes = Themes.GetThemes(ThemeManager.PresentAreaID, true, false);
                if (themes == null)
                    throw new Exception(string.Format("{0}下没有任何主题", ThemeManager));
                theme = themes.First();
            }

            string commonCssPath = Globals.GetFullUrlInResourceSite(string.Format("{0}/{1}/common.css", themeLocation, theme.DirectoryName));
            SpaceBuilder.Web.Header.AddStyle(commonCssPath, "screen", StyleRelativePosition.Last);

            //是否使用默认Appearance
            bool useDefaultAppearance = false;

            if (string.IsNullOrEmpty(themeAppearanceName) || themeAppearanceName.Equals(theme.DefaultAppearanceName, StringComparison.InvariantCultureIgnoreCase))
                useDefaultAppearance = true;

            ThemeAppearance themeAppearance = null;
            if (useDefaultAppearance == false)
            {
                themeAppearance = Themes.GetThemeAppearance(ThemeManager.PresentAreaID, themeName, themeAppearanceName, true, false);
                if (themeAppearance == null)
                    useDefaultAppearance = true;
            }

            if (useDefaultAppearance == true)
            {
                string cssPath = Globals.GetFullUrlInResourceSite(string.Format("{0}{1}", themeLocation, theme.DefaultAppearance.CssFileNameWithPath));
                SpaceBuilder.Web.Header.AddStyle(cssPath, "screen", StyleRelativePosition.Last);
                SpaceBuilder.Web.Header.SetLogoUrl(theme.DefaultAppearance.LogoUrl);

            }
            else if (themeAppearance != null)
            {
                string appearanceCssPath = Globals.GetFullUrlInResourceSite(string.Format("{0}{1}", themeLocation, themeAppearance.CssFileNameWithPath));
                SpaceBuilder.Web.Header.AddStyle(appearanceCssPath, "screen", StyleRelativePosition.Last);
                SpaceBuilder.Web.Header.SetLogoUrl(themeAppearance.LogoUrl);
            }

            if (theme.EnablePrintCSS)
            {
                string printCssPath = Globals.GetFullUrlInResourceSite(string.Format("{0}{1}/appearances/{2}/print.css", themeLocation, themeName, theme.DefaultAppearanceName));
                SpaceBuilder.Web.Header.AddStyle(printCssPath, "print", StyleRelativePosition.Last);
            }
        }
        #region  属性
        private User currentUser = null;
        /// <summary>
        /// 当前用户
        /// </summary>
        protected User CurrentUser
        {
            get
            {
                if (currentUser == null)
                    currentUser = Globals.GetCurrentUser();

                return currentUser;
            }
        }
        private string currentUserLanguage = string.Empty;
        /// <summary>
        /// 当前用户的语言设置
        /// 如果是匿名用户，可能存放在Cookiee中
        /// </summary>
        protected string CurrentUserLanguage
        {
            get
            {
                if (string.IsNullOrEmpty(currentUserLanguage))
                    currentUserLanguage = Globals.GetCurrentUserLanguage();
                return currentUserLanguage;
            }
        }
        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage);
        }
        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <param name="applicationID">应用ID</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey, int applicationID)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage, applicationID);
        }
        #endregion
    }

}
