﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using System.Web.Mvc;

namespace SpaceBuilder.Web
{
    public abstract class SPBViewUserControl : ViewUserControl
    {
        #region  属性
        private User currentUser = null;
        /// <summary>
        /// 当前用户
        /// </summary>
        protected User CurrentUser
        {
            get
            {
                if (currentUser == null)
                    currentUser = Globals.GetCurrentUser();

                return currentUser;
            }
        }
        private string currentUserLanguage = string.Empty;
        /// <summary>
        /// 当前用户的语言设置
        /// 如果是匿名用户，可能存放在Cookiee中
        /// </summary>
        protected string CurrentUserLanguage
        {
            get
            {
                if (string.IsNullOrEmpty(currentUserLanguage))
                    currentUserLanguage = Globals.GetCurrentUserLanguage();
                return currentUserLanguage;
            }
        }

        #endregion

        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage);
        }
        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <param name="applicationID">应用ID</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey, int applicationID)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage, applicationID);
        }
    }

    public abstract class SPBViewUserControl<TModel> : ViewUserControl<TModel> where TModel : class
    {
        #region  属性
        private User currentUser = null;
        /// <summary>
        /// 当前用户
        /// </summary>
        protected User CurrentUser
        {
            get
            {
                if (currentUser == null)
                    currentUser = Globals.GetCurrentUser();

                return currentUser;
            }
        }
        private string currentUserLanguage = string.Empty;
        /// <summary>
        /// 当前用户的语言设置
        /// 如果是匿名用户，可能存放在Cookiee中
        /// </summary>
        protected string CurrentUserLanguage
        {
            get
            {
                if (string.IsNullOrEmpty(currentUserLanguage))
                    currentUserLanguage = Globals.GetCurrentUserLanguage();
                return currentUserLanguage;
            }
        }
        #endregion


        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage);
        }
        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <param name="applicationID">应用ID</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey, int applicationID)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage, applicationID);
        }
    }
}
