﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.Web
{
    /// <summary>
    /// 空间内ViewPage基类
    /// </summary>
    public class UserDomainViewPage : SPBViewPage
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return UserPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }
            else if (!siteSettings.EnableAnonymousBrowse && !Request.IsAuthenticated)
            {
                Response.Redirect(SiteUrls.Instance().Login(true), true);
                return;
            }

            base.OnLoad(e);


        }
    }


    /// <summary>
    /// 空间内ViewPage泛型基类
    /// </summary>
    public class UserDomainViewPage<TModel> : SPBViewPage<TModel> where TModel : class
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return UserPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }
            else if (!siteSettings.EnableAnonymousBrowse && !Request.IsAuthenticated)
            {
                Response.Redirect(SiteUrls.Instance().Login(true), true);
                return;
            }

            base.OnLoad(e);
        }
    }
}