﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 用户头像类型
    /// </summary>
    public enum UserAvatarType
    {
        /// <summary>
        /// 正常显示用户已经上传的头像
        /// </summary>
        Normal,

        /// <summary>
        /// 隐藏的
        /// </summary>
        HideAvatar,

        /// <summary>
        /// 未上传头像用户，未设置性别
        /// </summary>
        NoAvatar_Default,

        /// <summary>
        /// 未上传头像用户，性别设置为男
        /// </summary>
        NoAvatar_Male,

        /// <summary>
        /// 未上传头像用户，性别设置为女
        /// </summary>
        NoAvatar_Female,
        
        /// <summary>
        /// 企业用户的默认头像
        /// </summary>
        NoAvatar_DefaultForCompany
    }

}
