﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Utils;
using System.ComponentModel;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// ControllerContext扩展方法
    /// </summary>
    public static class ControllerContextExtension
    {
        /// <summary>
        /// 从RouteData或QueryString中获取参数 
        /// </summary>
        /// <param name="controllerContext">ControllerContext</param>
        /// <param name="key">参数名称</param>
        /// <returns>字符串类型的参数值</returns>
        public static string GetParameterFromRouteDateOrQueryString(this ControllerContext controllerContext, string key)
        {
            if (controllerContext.RouteData.Values != null && controllerContext.RouteData.Values.ContainsKey(key))
            {
                object resultValue = null;
                if (controllerContext.RouteData.Values.TryGetValue(key, out resultValue) && resultValue != null)
                {
                    return resultValue.ToString();//.Replace('<', ' ').Replace('>', ' ').Replace("%3C", "&lt;").Replace("%3E", "&gt;");
                }
            }

            return controllerContext.HttpContext.Request.QueryString[key];
        }


        /// <summary>
        /// 从RouteData或QueryString中获取参数 
        /// </summary>
        /// <param name="controllerContext">ControllerContext</param>
        /// <param name="key">参数名称</param>
        /// <param name="defaultValue">默认返回值</param>
        /// <returns>字符串类型的参数值</returns>
        public static int GetParameterFromRouteDateOrQueryString(this ControllerContext controllerContext, string key, int defaultValue)
        {
            int returnValue = -1;
            if (controllerContext.RouteData.Values != null && controllerContext.RouteData.Values.ContainsKey(key))
            {
                object resultObject = null;
                if (controllerContext.RouteData.Values.TryGetValue(key, out resultObject) && resultObject != null)
                {
                    if (int.TryParse(resultObject.ToString(), out returnValue))
                        return returnValue;
                }
            }

            if (int.TryParse(controllerContext.HttpContext.Request.QueryString[key], out returnValue))
                return returnValue;

            return defaultValue;
        }

        /// <summary>
        /// 从RouteData或QueryString中获取参数
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="controllerContext">ControllerContext</param>
        /// <param name="key">参数名称</param>
        public static T GetParameterFromRouteDateOrQueryString<T>(this ControllerContext controllerContext, string key)
        {
            if (controllerContext.RouteData.Values != null && controllerContext.RouteData.Values.ContainsKey(key))
            {
                object resultValue = null;
                controllerContext.RouteData.Values.TryGetValue(key, out resultValue);
                if (resultValue != null)
                {
                    Type tType = typeof(T);
                    if (tType.IsInterface || tType.IsClass)
                    {
                        if (resultValue is T)
                            return (T)resultValue;
                        else
                            return default(T);
                    }
                    else if (tType.IsGenericType && tType.GetGenericTypeDefinition() == typeof(Nullable<>))
                    {
                        return (T)Convert.ChangeType(resultValue, Nullable.GetUnderlyingType(tType));
                    }
                    else if (tType.IsEnum)
                    {
                        return (T)Enum.Parse(tType, resultValue.ToString());
                    }
                    else
                    {
                        return (T)Convert.ChangeType(resultValue, tType);
                    }
                }
            }

            string temp = controllerContext.HttpContext.Request.QueryString[key];
            if (string.IsNullOrEmpty(temp) || temp.Trim().Length == 0)
            {
                return default(T);
            }

            Type type = typeof(T);
            if (type.IsGenericType && type.GetGenericTypeDefinition() == typeof(Nullable<>))
            {
                return (T)Convert.ChangeType(temp, Nullable.GetUnderlyingType(type));
            }
            else if (type.IsEnum)
            {
                return (T)Enum.Parse(type, temp);
            }
            else
            {
                return (T)Convert.ChangeType(temp, typeof(T));
            }
        }
    }
}