﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// System.Web.Mvc.HtmlHelper扩展
    /// </summary>
    public static class HtmlHelperExtension
    {
        /// <summary>
        /// 从RouteData或QueryString中获取参数
        /// </summary>
        /// <param name="htmlHelper"></param>
        /// <param name="key">参数名称</param>
        /// <returns>字符串类型的参数值</returns>
        public static string GetParameterFromRouteDateOrQueryString(this HtmlHelper htmlHelper, string key)
        {
            return htmlHelper.ViewContext.GetParameterFromRouteDateOrQueryString(key);
        }

        /// <summary>
        /// 从RouteData或QueryString中获取参数 
        /// </summary>
        /// <param name="controllerContext">ControllerContext</param>
        /// <param name="key">参数名称</param>
        /// <param name="defaultValue">默认返回值</param>
        /// <returns>字符串类型的参数值</returns>
        public static int GetParameterFromRouteDateOrQueryString(this HtmlHelper htmlHelper, string key, int defaultValue)
        {
            return htmlHelper.ViewContext.GetParameterFromRouteDateOrQueryString(key, defaultValue);
        }

        /// <summary>
        /// 从RouteData或QueryString中获取参数
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="htmlHelper"></param>
        /// <param name="key">参数名称</param>
        /// <returns></returns>
        public static T GetParameterFromRouteDateOrQueryString<T>(this HtmlHelper htmlHelper, string key)
        {
            return htmlHelper.ViewContext.GetParameterFromRouteDateOrQueryString<T>(key);
        }

        /// <summary>
        /// 事件日历
        /// </summary
        /// <remarks>
        /// 可用于博客日历及活动日历
        /// </remarks>
        /// <param name="helper">the HtmlHelper object</param>
        /// <param name="name">the name of the calendar</param>
        /// <param name="selectedDate">the date to show int the calendar</param>
        /// <param name="rawDates">the DateTime array</param>
        /// <param name="controllerName">the controller name</param>
        /// <param name="actionName">the action name</param>
        public static string Calendar(this HtmlHelper helper, DateTime calendarMonth, Dictionary<int, string> selectedDays,
            string controllerName, string actionName)
        {
            Calendar cal = new Calendar("spbCalender", calendarMonth, selectedDays, helper, controllerName, actionName);
            return cal.ToString();
        }

        /// <summary>
        /// 事件日历
        /// </summary
        /// <remarks>
        /// 可用于博客日历及活动日历
        /// </remarks>
        /// <param name="helper">the HtmlHelper object</param>
        /// <param name="name">the name of the calendar</param>
        /// <param name="selectedDate">the date to show int the calendar</param>
        /// <param name="rawDates">the DateTime array</param>
        /// <param name="controllerName">the controller name</param>
        /// <param name="actionName">the action name</param>
        public static string Calendar(this HtmlHelper helper, string name, DateTime calendarMonth, Dictionary<int, string> selectedDays,
            string controllerName, string actionName)
        {
            Calendar cal = new Calendar(name, calendarMonth, selectedDays, helper, controllerName, actionName);
            return cal.ToString();
        }

    }
}
