﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Caching;

namespace SpaceBuilder.Common
{
    public class OAuthTokenKey2Secret
    {
        /// <summary>
        /// 追加一条记录
        /// </summary>
        /// <param name="key"></param>
        /// <param name="secret"></param>
        public static void AddKey2Secret(string key, string secret)
        {
            string cacheKey = GetCacheKey_DictionaryOfKey2Secret();
            SynchronizedDictionary<string, string> dictionaryOfKey2Secret = CacheRepository.Get(cacheKey, true) as SynchronizedDictionary<string, string>;
            if (dictionaryOfKey2Secret == null)
                dictionaryOfKey2Secret = new SynchronizedDictionary<string, string>();
            dictionaryOfKey2Secret[key] = secret;
            CacheRepository.AddOrReplace(cacheKey, dictionaryOfKey2Secret, CachingExpirationTypes.UsualObjectCollection);
        }

        /// <summary>
        /// 通过key获取Secret
        /// </summary>
        /// <param name="key">key</param>
        public static string GetSecret(string key)
        {
            string cacheKey = GetCacheKey_DictionaryOfKey2Secret();
            SynchronizedDictionary<string, string> dictionaryOfKey2Secret = CacheRepository.Get(cacheKey, true) as SynchronizedDictionary<string, string>;
            if (dictionaryOfKey2Secret != null)
                return dictionaryOfKey2Secret[key];
            return null;
        }

        private static string GetCacheKey_DictionaryOfKey2Secret()
        {
            return "DictionaryOfKey2Secret";
        }


    }
}
