﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common.Controllers;
using System.Web.Mvc;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using SpaceBuilder.Club;
using System.Web.Routing;


namespace SpaceBuilder.Event.Controllers
{
    /// <summary>
    /// 群组中有关活动的Controller
    /// </summary>
    [HttpCompress]
    public class ClubEventController : ClubDomainControllerBase
    {
        private int EventApplicationID = ApplicationIDs.Instance().Event();
        /// <summary>
        /// 群组活动首页
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [ClubMemberVisitAndClubDomainHitTimeAttribute]
        public ActionResult Home(string clubDomainName)
        {
            SpaceBuilder.Club.Club currentClub = GetCurrentClub(clubDomainName);
            SetPageTitle(GetResourceString("Title_ClubEventHome", EventApplicationID), clubDomainName);
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_Event", EventApplicationID), SPBUrlHelper.Action("Home", "ClubEvent", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            if (!ClubPermission.AccessCheck(currentClub, CurrentUser, PermissionItemKeys.Instance().ViewClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();
            string applicationNameInclub = GetResourceString("Navigation_Event", EventApplicationID);

            IList<EventThread> hotEvents = EventThreads.GetTopThreadsSortByForClub(currentClub.ClubID, 10);
            return View("Pages/Events/Home.aspx", "Masters/Event.master", hotEvents);
        }
        /// <summary>
        /// 搜索活动
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult SearchEvent(string clubDomainName)
        {
            SpaceBuilder.Club.Club currentClub = GetCurrentClub(clubDomainName);
            if (currentClub == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_UserDomainNotFind"), clubDomainName)));
            }
            RouteValueDictionary parameters = new RouteValueDictionary();
            parameters["ClubID"] = currentClub.ClubID;
            parameters["EventNameFilter"] = Request.Form.GetString("eventNameFilter", string.Empty).Trim();
            return RedirectToAction("Search", "ChannelEvent", parameters);
        }
        /// <summary>
        /// 群组活动列表控件
        /// </summary>
        public ActionResult Control_ListEvents(string clubDomainName, EventStatuses? status, EventThreadSortBy? sortBy, int? pageIndex)
        {
            SpaceBuilder.Club.Club currentClub = GetCurrentClub(clubDomainName);
            if (currentClub == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_UserDomainNotFind"), clubDomainName)));
            }
            string controlTitle = GetResourceString("Title_BrowseClubEvent", EventApplicationID);
            User currentUser = Globals.GetCurrentUser();
            PagingDataSet<EventThread> pds = EventThreads.GetPagingThreadsForClub(currentClub.ClubID, status ?? EventStatuses.Published, pageIndex ?? 1);
            if (currentUser != null && ClubMembers.IsClubMember(currentClub.ClubID, CurrentUser.UserID))
                ViewData["IsClubMember"] = true;
            ViewData["ControlTitle"] = controlTitle;
            ViewData["ClubID"] = currentClub.ClubID;
            ViewData["status"] = status;
            ViewData["sortBy"] = sortBy;
            return PartialView("Controls/Events/ListEvents.ascx", pds);
        }

        /// <summary>
        /// 显示活动简单列表
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult Control_ListEventsBlock(string clubDomainName, int? displayCount, EventThreadSortBy? sortBy)
        {
            SpaceBuilder.Club.Club currentClub = GetCurrentClub(clubDomainName);
            IList<EventThread> eventThreads = EventThreads.GetTopThreadsSortByForClub(currentClub.ClubID, displayCount ?? 5);
            ViewData["sortBy"] = (int)sortBy;
            ViewData["ClubID"] = currentClub.ClubID;
            if (CurrentUser != null && ClubMembers.IsClubMember(currentClub.ClubID, CurrentUser.UserID))
                ViewData["IsClubMember"] = true;
            return PartialView("Controls/Events/ListEventsBlock.ascx", eventThreads);
        }
    }
}
