﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Event
{
    public class EventDateFormatter
    {
        /// <summary>
        /// 格式化日期
        /// </summary>
        /// <param name="date">DateTime</param>
        /// <param name="showTime">是否显示时间</param>
        /// <returns>格式化后的字符串</returns>
        public static string FormatDate(DateTime startTime, DateTime endTime, bool showTime)
        {
            if (!showTime && DateTime.Compare(startTime.Date, endTime.Date) == 0)
                return FormatDate(startTime, false);

            return FormatDate(startTime, showTime) + " - " + FormatDate(endTime, showTime);
        }


        /// <summary>
        /// 转换成用户所在时区的时间
        /// </summary>
        /// <param name="date">被转换的时间</param>
        private static DateTime GetUserDate(DateTime date, User user)
        {
            if (user == null)
                return date.AddHours(SiteSettingsManager.GetSiteSettings().SiteTimezone - SiteSettingsManager.GetSiteSettings().ServerTimezone);

            return date.AddHours(user.Timezone - SiteSettingsManager.GetSiteSettings().ServerTimezone);
        }

        /// <summary>
        /// 格式化日期
        /// </summary>
        /// <param name="date">DateTime</param>
        /// <param name="showTime">是否显示时间</param>
        /// <returns>格式化后的字符串</returns>
        public static string FormatDate(DateTime date, bool showTime)
        {
            if (date == DateTime.MinValue)
                return ResourceManager.GetString("Common_NumberWhenZero", Globals.GetCurrentUserLanguage());
            User currentUser = Globals.GetCurrentUser();
            date = GetUserDate(date, currentUser);

            string dateFormat = ResourceManager.GetString("Common_EventDateFormat", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().Event());
            if (date.Year != DateTime.Now.Year)
                dateFormat = ResourceManager.GetString("Common_EventFullDateFormat", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().Event());
            string timeFormat = ResourceManager.GetString("Common_DefaultTimeFormat", Globals.GetCurrentUserLanguage());
            if (string.IsNullOrEmpty(dateFormat))
                dateFormat = SiteSettingsManager.GetSiteSettings().DateFormat;
            if (showTime)
                return date.ToString(dateFormat + " " + timeFormat);
            else
                return date.ToString(dateFormat);
        }
    }
}