﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
//     Copyright (c) Tunynet Inc.  All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.IO;
using SpaceBuilder.Common;
using SpaceBuilder.Event;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Event.Handlers
{
    public class ExportEventMembersToCSVHandler : IHttpHandler
    {

        #region IHttpHandler 成员


        public void ProcessRequest(HttpContext context)
        {
            try
            {
                int eventID = -1;
                if (!string.IsNullOrEmpty(context.Request.QueryString["eventID"]))
                    int.TryParse(context.Request.QueryString["eventID"], out eventID);

                bool? isApproved = null;

                if (!string.IsNullOrEmpty(context.Request.QueryString["isApproved"]))
                {
                    bool isApprovedValue = false;
                    bool.TryParse(context.Request.QueryString["isApproved"], out isApprovedValue);
                    isApproved = isApprovedValue;
                }
                if (eventID > 0)
                {
                    EventThread eventThread = EventThreads.GetEvent(eventID, false);
                    if (eventThread == null || !EventPermission.Validate(eventThread, Globals.GetCurrentUser(), PermissionItemKeys.Instance().ManageEventMembers()))
                        return;

                    context.Response.Clear();
                    context.Response.ContentType = "text/csv";
                    string filename = string.Empty;
                    if (context.Request.UserAgent.Contains("Firefox"))
                        filename = StringUtils.Trim(eventThread.EventName, 10) + "(成员名单)" + ".csv";
                    else
                        filename = HttpUtility.UrlEncode(StringUtils.Trim(eventThread.EventName, 10) + "(成员名单)" + ".csv");

                    context.Response.AddHeader("Content-Disposition", "attachment;filename=" + filename);
                    EventMembers.ExprotMembersToCSV(context.Response.OutputStream, eventThread.EventID, isApproved);
                    //context.Response.End;
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(ex.ToString());
            }
        }

        public bool IsReusable
        {
            get { return false; }
        }

        #endregion
    }
}