﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Common;
using System.Drawing;

namespace SpaceBuilder.Event.Handlers
{
    public class UploadEventLogoHandler : IHttpHandler
    {
        #region IHttpHandler 成员

        public void ProcessRequest(HttpContext context)
        {
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));
            int currentAssociateID = Convert.ToInt32(context.Request["associateID"]);

            if (currentAssociateID < 1)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }
            User currentUser = Users.GetUser(currentUserID, false);
            if (currentUser == null)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            EventThread eventThread = EventThreads.GetEvent(currentAssociateID,false);
            if (!EventPermission.Validate(eventThread, currentUser, PermissionItemKeys.Instance().EditEvent()))
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            System.Web.HttpPostedFile LogoFile = context.Request.Files["Filedata"];

            if (LogoFile == null || LogoFile.ContentLength == 0)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            if (LogoFile.ContentLength > 5 * 1024 * 1024)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            //Todo: 类型判断
            string uploadPhotoTypes = EventAttachmentManager.Instance().Settings.Extensions;
            string[] types = uploadPhotoTypes.Split(',');
            string fileTypeString = LogoFile.FileName.Substring(LogoFile.FileName.LastIndexOf(".") + 1);

            if (types.Count(n => string.Compare(n, fileTypeString, true) == 0) <= 0)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            double length = EventAttachmentManager.Instance().Settings.MaxAttachmentSize;
            if (LogoFile.ContentLength > length * 1024)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            EventPhoto photo = new EventPhoto(EventAttachmentManager.Instance().StorageProviderName, LogoFile.FileName);
            photo.AssociateID = currentAssociateID;
            photo.OwnerID = currentAssociateID;
            photo.UserID = currentUser.UserID;
            photo.Author = currentUser.DisplayName;
            photo.EventID = currentAssociateID;

            photo.ContentSize = LogoFile.ContentLength;
            photo.ContentType = MimeTypeConfiguration.GetMimeType(LogoFile.FileName);
            photo.DateCreated = DateTime.Now;
            photo.FriendlyFileName = LogoFile.FileName.Substring(LogoFile.FileName.LastIndexOf("\\") + 1);
            //创建活动图片
            EventPhotos.CreateEventPhoto(photo, LogoFile.InputStream);
            if (photo.AttachmentID > 0)
            {
                //将活动图片更新为活动标识
                EventPhotos.UpdateEventLogo(photo);
                context.Response.StatusCode = 200;
                context.Response.Write("{refresh:true}");
                context.Response.End();
            }
            context.Response.StatusCode = 403;
            context.Response.End();
        }

        public bool IsReusable
        {
            get { return false; }
        }
        #endregion
    }
}
