﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common.Handlers;
using System.Web;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;

namespace SpaceBuilder.Event.Handlers
{
    public class UploadEventPhotosHandler : IHttpHandler
    {

        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            // 验证是否有上传图片的权限
            int currentEventID = Convert.ToInt32(context.Request["associateID"]);
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));
            User currentUser = Users.GetUser(currentUserID, false);
            if (currentUser == null)
            {
                WebUtils.Return404(context);
                return;
            }
            if (currentEventID > 0)
            {
                EventThread currentEventThread = EventThreads.GetEvent(currentEventID, false);
                if (currentEventThread == null)
                {
                    WebUtils.Return404(context);
                    return;
                }

                if (!EventPermission.Validate(currentEventThread, currentUser, PermissionItemKeys.Instance().UploadEventPhoto()))
                {
                    WebUtils.Return404(context);
                    return;
                }
            }
            System.Web.HttpPostedFile postedFile = context.Request.Files["Filedata"];

            string fileName = postedFile.FileName;
            int contentLength = postedFile.ContentLength;

            bool isPermitted = true;

            if (string.IsNullOrEmpty(fileName) && contentLength <= EventAttachmentManager.Instance().Settings.MaxAttachmentSize * 1024)
            {
                WebUtils.Return404(context);
                return;
            }

            if (!currentUser.IsContentAdministrator && postedFile.ContentLength / 1024 > (currentUser.DatabaseQuota - currentUser.DatabaseQuotaUsed))
            {
                context.Response.StatusCode = 200;
                context.Response.Write("{message:'空间容量不足'}");
                context.Response.End();
            }

            if (isPermitted)
            {
                string fileTypeString = fileName.Substring(fileName.LastIndexOf(".") + 1);
                string uploadPhotoTypes = EventAttachmentManager.Instance().Settings.Extensions;
                if (!uploadPhotoTypes.ToLower().Contains(fileTypeString.ToLower()))
                {
                    isPermitted = false;
                }
            }

            if (isPermitted)
            {
                EventPhoto eventPhoto = new EventPhoto(EventAttachmentManager.Instance().StorageProviderName, null);
                eventPhoto.UserID = currentUser.UserID;
                eventPhoto.Author = currentUser.DisplayName;
                eventPhoto.ContentSize = contentLength;
                eventPhoto.ContentType = MimeTypeConfiguration.GetMimeType(fileName);
                eventPhoto.FriendlyFileName = fileName;
                eventPhoto.UserHostAddress = WebUtils.IPAddress;
                if (currentEventID > 0)
                {
                    eventPhoto.AssociateID = currentEventID;
                    EventPhotos.CreateEventPhoto(eventPhoto, postedFile.InputStream);
                }
                else
                {
                    EventAttachmentManager.Instance().CreateTemporaryAttachment(eventPhoto, postedFile.InputStream);
                }
           

            }
            context.Response.StatusCode = 200;
            context.Response.Write("{ok:true}");
            context.Response.End();
        }
        #endregion
    }
}
