﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using SpaceBuilder.Club;

namespace SpaceBuilder.Event.Modules
{
    /// <summary>
    /// 创建有关活动的动态
    /// </summary>
    public class DisposeActivityForEvent : IEventModule
    {
        #region IEventModule 成员

        public void Init(EventEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterEventChange += new EventEventHandler(em_AfterEventChange);

            em.AfterEventPostChange += new EventPostEventHandler(em_AfterEventPostChange);

            em.AfterEventMemberChange += new EventMemberEventHandler(em_AfterEventMemberChange);

            em.AfterEventPhotoChange += new EventPhotoEventHandler(em_AfterEventPhotoChange);

            em.AfterEventPhotoCommentChange += new EventPhotoCommentEventHandler(em_AfterEventPhotoCommentChange);
        }

        #endregion

        void em_AfterEventPhotoCommentChange(EventPhotoComment eventPhotoComment, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewEventPhotoComment();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                User user = Users.GetUser(eventPhotoComment.UserID, false);

                if (user == null)
                    return;

                EventPhoto photo = EventPhotos.GetEventPhoto(eventPhotoComment.AttachmentID, false);
                if (photo == null)
                    return;
                EventThread eventThread = EventThreads.GetEvent(photo.EventID, false);
                if (eventThread == null)
                    return;

                #region 处理个人动态
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;

                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewEventPhotoComment", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetEventPhotoNameWithHyperlink(photo));
                userActivity.Body = GetEventPhotoHtml(photo, 50);
                userActivity.IsPublic = eventThread.IsPublic;

                userActivity.RelativeItemID = photo.AttachmentID;
                userActivity.RelativeItemName = photo.FriendlyFileName;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region 处理朋友动态
                if (eventThread.IsPublic)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //判断用户是否允许发送给 朋友动态项目

                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;
                        friendActivity.Body = GetEventPhotoHtml(photo, 50);
                        friendActivity.RelativeItemID = photo.AttachmentID;
                        friendActivity.RelativeItemName = photo.FriendlyFileName;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }

        void em_AfterEventChange(EventThread eventThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewEventThread();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                User user = Users.GetUser(eventThread.UserID, false);

                if (user == null)
                    return;

                #region 处理个人动态
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;

                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewEventThread", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetEventNameWithHyperlink(eventThread));

                userActivity.IsPublic = eventThread.IsPublic;

                userActivity.RelativeItemID = eventThread.EventID;
                userActivity.RelativeItemName = eventThread.EventName;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region 处理朋友动态
                if (eventThread.IsPublic)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //判断用户是否允许发送给 朋友动态项目

                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;

                        friendActivity.RelativeItemID = eventThread.EventID;
                        friendActivity.RelativeItemName = eventThread.EventName;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion

                #region 处理群组动态
                if (eventThread.ClubID > 0)
                {
                    ClubActivity clubActivity = new ClubActivity();
                    clubActivity.ApplicationID = ApplicationIDs.Instance().Event();
                    clubActivity.ClubID = eventThread.ClubID;
                    clubActivity.LeadingActorUserID = user.UserID;
                    clubActivity.LeadingActor = user.DisplayName;
                    clubActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewEventThread", user.Language, e.ApplicationID), string.Empty, GetEventNameWithHyperlink(eventThread)); ;
                    clubActivity.Body = userActivity.Body;
                    clubActivity.RelativeItemID = eventThread.EventID;
                    clubActivity.RelativeItemName = eventThread.EventName;
                    ClubActivities.CreateClubActivity(clubActivity);
                    if (clubActivity.ActivityID > 0)
                    {
                        PagingDataSet<ClubMember> members = ClubMembers.GetMembers(clubActivity.ClubID, null, null, ValueHelper.GetSafeSqlInt(int.MaxValue), 1, false);
                        List<int> memberIDs = new List<int>();
                        foreach (ClubMember member in members.Records)
                        {
                            memberIDs.Add(member.UserID);
                        }
                        ClubActivities.SendToClubMembers(clubActivity.ActivityID, ApplicationIDs.Instance().Event(), memberIDs);
                    }
                }

                #endregion

            }
        }


        void em_AfterEventPostChange(EventPost eventPost, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewEventPost();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                User user = Users.GetUser(eventPost.UserID, false);
                if (user == null)
                    return;
                EventThread eventThread = EventThreads.GetEvent(eventPost.EventID, false);

                #region 处理个人动态
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewEventPost", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetEventNameWithHyperlink(eventThread));
                userActivity.Body = HtmlUtils.TrimHtml(eventPost.Body, 250);

                userActivity.IsPublic = eventThread.IsPublic;
                userActivity.RelativeItemID = eventPost.PostID;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region 处理朋友动态
                if (eventThread.IsPublic)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //判断用户是否允许发送给 朋友动态项目
                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;
                        friendActivity.Body = HtmlUtils.TrimHtml(eventPost.Body, 250);

                        friendActivity.RelativeItemID = eventPost.PostID;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }

        void em_AfterEventMemberChange(EventMember eventMember, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewEventMember();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;

                User user = Users.GetUser(eventMember.UserID, false);
                EventThread eventThread = EventThreads.GetEvent(eventMember.EventID, false);
                if (eventThread.UserID == eventMember.UserID)
                    return;

                #region 处理个人动态
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                if (user != null)
                    userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = SPBHtmlHelper.Instance().UserDisplayName(user);
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewEventMember", Globals.GetCurrentUserLanguage(), e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetEventNameWithHyperlink(eventThread));
                userActivity.IsPublic = eventThread.IsPublic;
                userActivity.RelativeItemID = eventMember.MemberID;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region 处理朋友动态
                if (Globals.GetCurrentUser() != null && eventThread.IsPublic)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //判断用户是否允许发送给 朋友动态项目
                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;

                        friendActivity.RelativeItemID = eventMember.MemberID;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }

        void em_AfterEventPhotoChange(EventPhoto eventPhoto, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewEventPhoto();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);

                User user = Users.GetUser(eventPhoto.UserID, false);
                if (user == null)
                    return;
                EventThread eventThread = EventThreads.GetEvent(eventPhoto.EventID, false);

                #region 处理个人动态
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewEventPhoto", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetEventNameWithHyperlink(eventThread));
                userActivity.Body = GetEventPhotoHtml(eventPhoto, 50);

                userActivity.IsPublic = eventThread.IsPublic;
                userActivity.RelativeItemID = eventPhoto.AttachmentID;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region 处理朋友动态
                if (eventThread.IsPublic)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //判断用户是否允许发送给 朋友动态项目
                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(ActivityItemKeys.Instance().NewEventPhoto()))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;
                        friendActivity.Body = GetEventPhotoHtml(eventPhoto, 50);

                        friendActivity.RelativeItemID = eventPhoto.AttachmentID;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, ActivityItemKeys.Instance().NewEventPhoto());
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }

        /// <summary>
        /// 获取带链接的图片名称的html代码
        /// </summary>
        private static string GetEventPhotoNameWithHyperlink(EventPhoto photo)
        {
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowEventPhoto(photo.AttachmentID), photo.FriendlyFileName);
        }



        /// <summary>
        /// 图片的html呈现代码
        /// </summary>
        public static string GetEventPhotoHtml(EventPhoto eventPhoto, int pictureHeight)
        {
            string pictureUrl = SiteUrls.Instance().EventPhotoUrl(eventPhoto.AttachmentID, EventPhotoTypes.Thumbnail);
            return string.Format("<img src=\"{0}\" border=\"0\" height=\"{1}\" alt=\"{2}\" />", pictureUrl, pictureHeight, eventPhoto.FriendlyFileName);
        }


        /// <summary>
        /// 获取带链接的活动名称的html代码
        /// </summary>
        private static string GetEventNameWithHyperlink(EventThread eventThread)
        {
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowEvent(eventThread.EventID), eventThread.EventName);
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;
    }
}
