﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights  reserved.
// </copyright> 
//------------------------------------------------------------------------------ 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Club;

namespace SpaceBuilder.Event.Modules
{
    /// <summary>
    /// 删除群组时处理活动
    /// </summary>
    public class DisposeEventForDeleteClub : IClubModule
    {
        #region IEventModule 成员

        public void Init(ClubEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.BeforeClubChange += new ClubEventHandler(em_BeforeClubChange);
        }

        void em_BeforeClubChange(SpaceBuilder.Club.Club club, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Delete)
            {
                BlockPagingID ids = SqlEventDataProvider.Instance().GetEventThreadIDsForClub(club.ClubID, null, null, 5000, 5000, 1);
                if (ids != null)
                {
                    foreach (var eventID in ids.GetAll())
                    {
                        EventThreads.DeleteEvent(eventID);
                    }
                }

            }
        }

        #endregion
    }
}
