﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.Event.Modules
{
    public class DisposeEventMemberForEventInvitation : IServiceModule
    {
        #region IServiceModule 成员

        public void Init(ServiceEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.InvitationStatusChange += new InvitationEventHandler(gem_InvitationStatusChange);
        }

        void gem_InvitationStatusChange(Invitation invitation, GlobalEventArgs e)
        {
            if (e.ApplicationID == ApplicationIDs.Instance().Event())
            {
                if (invitation.Status == InvitationStatuses.Accept)
                {
                    User receiver = Users.GetUser(invitation.ReceiverUserID, false);
                    if (receiver == null)
                        return;
                    EventMember member = new EventMember();
                    member.EventID = invitation.RelativeItemID;
                    member.UserID = receiver.UserID;
                    member.DisplayName = receiver.DisplayName;
                    member.Email = receiver.PublicEmail;
                    if (receiver.UserType == UserTypes.PersonUser)
                    {
                        PersonUser pu = receiver as PersonUser;
                        member.Gender = pu.Gender;
                        member.Address = pu.PersonAddress;
                        member.Company = pu.CompanyName;
                        member.Job = pu.Title;
                        member.Moblie = pu.Mobile;
                        member.Telephone = pu.HomeTel;
                    }
                    member.IsApproved = true;
                    EventMembers.CreateEventMember(member);
                }
            }
        }

        #endregion
    }
}
