//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;

using System.Web;
using SpaceBuilder.Event;
using SpaceBuilder.Common;
using SpaceBuilder.Common.Mail;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Event.Modules
{
    /// <summary>
    /// ص֪ͨ
    /// </summary>
    public class DisposeNoticeForEvent : IEventModule
    {
        #region IEventModule Ա

        public void Init(EventEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterEventPostChange += new EventPostEventHandler(em_AfterEventPostChange);

            em.AfterEventMemberChange += new EventMemberEventHandler(em_AfterEventMemberChange);

            em.AfterEventPhotoChange += new EventPhotoEventHandler(em_AfterEventPhotoChange);
            //ȡ֪ͨ
            //em.AfterEventChange += new EventEventHandler(em_AfterEventChange);
            em.AfterEventPhotoCommentChange += new EventPhotoCommentEventHandler(em_AfterEventPhotoCommentChange);
        }

        void em_AfterEventPhotoCommentChange(EventPhotoComment photoComment, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {

                EventPhoto photo = EventPhotos.GetEventPhoto(photoComment.AttachmentID, false);

                string itemKey = NoticeItemKeys.Instance().NewEventPhotoComment();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                User toUser = Users.GetUser(photo.UserID, false);
                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().Event();
                record.UserID = toUser.UserID;
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.LeadingActorUserID = photoComment.UserID;
                record.LeadingActor = photoComment.Author;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Event());
                record.RelativeItemID = photo.AttachmentID;
                record.RelativeItemName = photo.FriendlyFileName;
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewEventPhotoComment", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(photoComment.UserID, photoComment.Author, true), GetEventPhotoNameWithHyperlink(photo));
                record.RelativeItemUrl = SiteUrls.Instance().ShowEventPhoto(photo.AttachmentID);
                record.Body = photoComment.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        #endregion

        //void em_AfterEventChange(EventThread eventThread, GlobalEventArgs e)
        //{
        //    if (e.State == ObjectState.Update && eventThread.EventStatus == EventStatuses.Canceled)
        //    {
        //        User user = Users.GetUser(eventThread.UserID);

        //        List<int> eventMemberUserIDs = new List<int>();
        //        Dictionary<int, EventMember> members = EventMembers.GetEventMemberUsers(eventThread.EventID);
        //        foreach (int userID in members.Keys)
        //        {
        //            if (members[userID].IsApproved)
        //                eventMemberUserIDs.Add(userID);
        //        }
        //        foreach (int eventMemberUserID in eventMemberUserIDs)
        //        {
        //            User toUser = Users.GetUser(eventMemberUserID);

        //            PrivateMessage pm = new PrivateMessage();
        //            pm.MessageType = PrivateMessageType.System;
        //            pm.IsLocked = true;
        //            pm.SenderUserID = (int)PrivateMessageEspecialUserID.System;
        //            pm.Receiver = toUser.DisplayName;
        //            pm.ReceiverUserID = toUser.UserID;
        //            //pm.Subject = emailTemplate.Subject;
        //            //pm.Body = emailTemplate.HtmlBody;
        //            PrivateMessages.SendMessage(pm);
        //        }

        //    }
        //}


        void em_AfterEventPostChange(EventPost eventPost, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                EventThread eventThread = EventThreads.GetEvent(eventPost.EventID, false);

                string itemKey = NoticeItemKeys.Instance().NewEventPost();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                List<int> eventMemberUserIDs = new List<int>();
                Dictionary<int, int> dictionary = EventMembers.GetUserID2MemberIDDictionaryOfEvent(eventThread.EventID);
                foreach (var pair in dictionary)
                {
                    EventMember eventMember = EventMembers.GetEventMember(pair.Value, false);
                    if (eventMember != null && eventMember.IsApproved)
                        eventMemberUserIDs.Add(pair.Key);
                }
                if (eventMemberUserIDs.Contains(eventPost.UserID))
                    eventMemberUserIDs.Remove(eventPost.UserID);
                foreach (int eventMemberUserID in eventMemberUserIDs)
                {
                    User toUser = null;
                    toUser = Users.GetUser(eventMemberUserID, false);
                    NoticeRecord record = new NoticeRecord();
                    record.ApplicationID = ApplicationIDs.Instance().Event();
                    record.NoticeItemID = noticeItem.ItemID;
                    record.NoticeItemKey = noticeItem.ItemKey;
                    record.UserID = toUser.UserID;
                    record.Receiver = toUser.UserName;
                    record.LeadingActorUserID = eventPost.UserID;
                    record.LeadingActor = eventPost.Author;
                    if (eventPost.UserID > 0)
                        record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Event());

                    record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewEventPost", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(eventPost.UserID, eventPost.Author, true),
                    GetEventNameWithHyperlink(eventThread), SiteUrls.Instance().ShowEvent(eventThread.EventID));
                    record.RelativeItemID = eventThread.EventID;
                    record.RelativeItemName = eventThread.EventName;
                    record.RelativeItemUrl = SiteUrls.Instance().ShowEvent(eventThread.EventID);
                    record.ProcessUrl = SiteUrls.Instance().ShowEvent(eventThread.EventID);
                    record.Body = eventPost.Body;
                    NoticeProcessorFactory.Instance().ProcessNotice(record);
                }
            }
        }

        void em_AfterEventMemberChange(EventMember eventMember, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                EventThread eventThread = EventThreads.GetEvent(eventMember.EventID, false);

                if (eventThread.UserID == eventMember.UserID)
                    return;
                if (eventMember.IsApproved == true)  //
                    return;

                string itemKey = NoticeItemKeys.Instance().NewEventMember();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;

                List<int> eventMemberUserIDs = new List<int>();
                Dictionary<int, int> dictionary = EventMembers.GetUserID2MemberIDDictionaryOfEvent(eventThread.EventID);
                foreach (var pair in dictionary)
                {
                    EventMember member = EventMembers.GetEventMember(pair.Value, true);
                    if (member != null && member.IsManager)
                        eventMemberUserIDs.Add(pair.Key);
                }
                foreach (int eventMemberUserID in eventMemberUserIDs)
                {

                    User toUser = null;
                    toUser = Users.GetUser(eventMemberUserID, false);

                    NoticeRecord record = new NoticeRecord();
                    record.ApplicationID = ApplicationIDs.Instance().Event();
                    record.NoticeItemID = noticeItem.ItemID;
                    record.NoticeItemKey = noticeItem.ItemKey;
                    record.UserID = toUser.UserID;
                    record.Receiver = toUser.UserName;
                    record.LeadingActorUserID = eventMember.UserID;
                    record.LeadingActor = eventMember.DisplayName;
                    if (eventMember.UserID > 0)
                        record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Event());
                    string needApprovedString = string.Format("<a href='{0}'>{1}</a>", SiteUrls.Instance().ManageEventMembers(eventThread.EventID), ResourceManager.GetString("Action_Notice_NeedApproved", toUser.Language, e.ApplicationID));
                    record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewEventMember", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(eventMember.UserID, eventMember.DisplayName, true), GetEventNameWithHyperlink(eventThread), needApprovedString);
                    record.RelativeItemID = eventThread.EventID;
                    record.RelativeItemName = eventThread.EventName;
                    record.RelativeItemUrl = SiteUrls.Instance().ShowEvent(eventThread.EventID);
                    record.ProcessUrl = SiteUrls.Instance().ManageEventMembers(eventThread.EventID);
                    NoticeProcessorFactory.Instance().ProcessNotice(record);
                }
            }
        }

        void em_AfterEventPhotoChange(EventPhoto eventPhoto, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                EventThread eventThread = EventThreads.GetEvent(eventPhoto.EventID, false);
                string itemKey = NoticeItemKeys.Instance().NewEventPhoto();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;

                List<int> eventMemberUserIDs = new List<int>();
                Dictionary<int, int> dictionary = EventMembers.GetUserID2MemberIDDictionaryOfEvent(eventThread.EventID);
                foreach (var pair in dictionary)
                {
                    EventMember eventMember = EventMembers.GetEventMember(pair.Value, false);
                    if (eventMember != null && eventMember.IsApproved)
                        eventMemberUserIDs.Add(pair.Key);
                }

                //ϴ߷֪ͨ
                if (eventMemberUserIDs.Contains(eventPhoto.UserID))
                    eventMemberUserIDs.Remove(eventPhoto.UserID);
                foreach (int eventMemberUserID in eventMemberUserIDs)
                {
                    User toUser = Users.GetUser(eventMemberUserID, false);
                    NoticeRecord record = new NoticeRecord();
                    record.ApplicationID = ApplicationIDs.Instance().Event();
                    record.NoticeItemID = noticeItem.ItemID;
                    record.NoticeItemKey = noticeItem.ItemKey;
                    record.UserID = toUser.UserID;
                    record.Receiver = toUser.UserName;
                    record.LeadingActorUserID = eventPhoto.UserID;
                    record.LeadingActor = eventPhoto.Author;
                    record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Event());
                    record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewEventPhoto", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(eventPhoto.UserID, eventPhoto.Author,true),
                    GetEventNameWithHyperlink(eventThread), GetEventPictureWithHyperlink(eventPhoto));
                    record.Body = eventPhoto.Description;
                    record.RelativeItemID = eventThread.EventID;
                    record.RelativeItemName = eventThread.EventName;
                    record.RelativeItemUrl = SiteUrls.Instance().ShowEvent(eventThread.EventID);
                    record.ProcessUrl = SiteUrls.Instance().ShowEventPhoto(eventPhoto.AttachmentID);
                    NoticeProcessorFactory.Instance().ProcessNotice(record);
                }
            }
        }

        /// <summary>
        /// ȡӵͼƬƵhtml
        /// </summary>
        private static string GetEventPhotoNameWithHyperlink(EventPhoto photo)
        {
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowEventPhoto(photo.AttachmentID), photo.FriendlyFileName);
        }

        /// <summary>
        /// ȡӵĻƬhtml
        /// </summary>
        private static string GetEventPictureWithHyperlink(EventPhoto eventPhoto)
        {
            return string.Format("<a {0} href='{1}'>{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowEventPhoto(eventPhoto.AttachmentID), eventPhoto.FriendlyFileName);
        }

        /// <summary>
        /// ȡӵĻƵhtml
        /// </summary>
        private static string GetEventNameWithHyperlink(EventThread eventThread)
        {
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowEvent(eventThread.EventID), eventThread.EventName);
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;
    }
}