//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common.Mail;

using SpaceBuilder.Event;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;

namespace SpaceBuilder.Event.Modules
{
    /// <summary>
    /// ص֪ͨ
    /// </summary>
    public class DisposeNoticeForEventInvitation : IServiceModule
    {
        #region IServiceModule Ա

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.NewInvitation += new InvitationEventHandler(em_NewInvitation);
        }

        void em_NewInvitation(Invitation invitation, GlobalEventArgs e)
        {
            if (e.ApplicationID == ApplicationIDs.Instance().Event() && e.State == ObjectState.Create)
            {
                string itemKey = NoticeItemKeys.Instance().InvitedJoinEvent();

                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                User user = null;
                user = Users.GetUser(invitation.SenderUserID, false);

                User toUser = null;
                toUser = Users.GetUser(invitation.ReceiverUserID, false);
                if (user == null || toUser == null  )
                    return;

                EventThread eventThread = EventThreads.GetEvent(invitation.RelativeItemID,false );

                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().Event();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.UserID = toUser.UserID;
                record.Receiver = toUser.UserName;
                record.LeadingActorUserID = invitation.SenderUserID;
                record.LeadingActor = invitation.Sender;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Event());
                string processItString = string.Format("<a href='{0}'>{1}</a>", SiteUrls.Instance().InvitationInbox(toUser.UserName),
                 ResourceManager.GetString("Action_Notice_ProcessIt", toUser.Language, e.ApplicationID));
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_InvitedJoinEvent", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true),
                GetEventNameWithHyperlink(eventThread), processItString);
                record.RelativeItemID = invitation.RelativeItemID;
                record.RelativeItemName = invitation.RelativeItemName;
                record.RelativeItemUrl = SiteUrls.Instance().ShowEvent(invitation.RelativeItemID);
                record.ProcessUrl = SiteUrls.Instance().InvitationInbox(toUser.UserName);
                record.Body = invitation.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        /// <summary>
        /// ȡӵĻƵhtml
        /// </summary>
        private static string GetEventNameWithHyperlink(EventThread eventThread)
        {
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowEvent(eventThread.EventID), eventThread.EventName);
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;
        #endregion
    }
}
