//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;
using SpaceBuilder.Event;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Event.Modules
{
    /// <summary>
    /// صĻ
    /// </summary>
    public class DisposePointForEvent : IEventModule
    {

        #region IEventModule Ա

        public void Init(EventEventManager em, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                em.AfterPointChangeOfEventThread += new PointChangeOfEventThreadHandler(em_AfterPointChangeOfEventThread);
                em.AfterPointChangeOfEventPhoto += new PointChangeOfEventPhotoHandler(em_AfterPointChangeOfEventPhoto);
                em.AfterPointChangeOfEventPhotoComment += new PointChangeOfEventPhotoCommentHandler(em_AfterPointChangeOfEventPhotoComment);
                em.AfterPointChangeOfEventPost += new PointChangeOfEventPostHandler(em_AfterPointChangeOfEventPost);
                em.EventFinished += new EventEventHandler(em_EventFinished);
            }
        }
        /// <summary>
        /// Ի
        /// </summary>
        void em_AfterPointChangeOfEventPost(EventPost eventPost, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            User user = Users.GetUser(eventPost.UserID, false);
            if (user == null)
                return;
            EventThread eventThread = EventThreads.GetEvent(eventPost.EventID, false);
            if (eventThread == null)
                return;

            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateEventPost());
                if (role == null)
                    return;
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateEventPost", user.Language, e.ApplicationID), eventThread.EventName);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_EventPostAuditingSuccess", user.Language, e.ApplicationID), eventThread.EventName);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteEventPost());
                if (role == null)
                    return;

                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteEventPost", user.Language, e.ApplicationID), eventThread.EventName);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_EventPostAuditingFail", user.Language, e.ApplicationID), eventThread.EventName);
            }
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, eventPost.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            if (role.HasTradePoints)
            {
                EventUserDatas.ChanageExperiencePoints(eventPost.UserID, role.TradePoints);
            }
            Points.CreateUserPointRecords(records);
        }

        /// <summary>
        /// Ƭۻ
        /// </summary>
        void em_AfterPointChangeOfEventPhotoComment(EventPhotoComment photoComment, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            User user = Users.GetUser(photoComment.UserID, false);
            if (user == null)
                return;
            EventPhoto photo = EventPhotos.GetEventPhoto(photoComment.AttachmentID, false);
            if (photo == null)
                return;
            EventThread eventThread = EventThreads.GetEvent(photo.EventID, false);
            if (eventThread == null)
                return;

            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateEventPhotoComment());
                if (role == null)
                    return;
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateEventPhotoComment", user.Language, e.ApplicationID), eventThread.EventName);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_EventPhotoCommentAuditingSuccess", user.Language, e.ApplicationID), eventThread.EventName);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteEventPhotoComment());
                if (role == null)
                    return;

                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteEventPhotoComment", user.Language, e.ApplicationID), eventThread.EventName);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_EventPhotoCommentAuditingFail", user.Language, e.ApplicationID), eventThread.EventName);
            }
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, photoComment.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            if (role.HasTradePoints)
            {
                EventUserDatas.ChanageExperiencePoints(photoComment.UserID, role.TradePoints);
            }
            Points.CreateUserPointRecords(records);
        }

        /// <summary>
        /// Ƭ
        /// </summary>
        void em_AfterPointChangeOfEventPhoto(EventPhoto eventPhoto, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            User user = Users.GetUser(eventPhoto.UserID, false);
            if (user == null)
                return;
            EventThread eventThread = EventThreads.GetEvent(eventPhoto.EventID, false);
            if (eventThread == null)
                return;

            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().UploadEventPhoto());
                if (role == null)
                    return;
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_UploadEventPhoto", user.Language, e.ApplicationID), eventPhoto.FriendlyFileName, eventThread.EventName);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_EventPhotoAuditingSuccess", user.Language, e.ApplicationID), eventPhoto.FriendlyFileName, eventThread.EventName);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteEventPhoto());
                if (role == null)
                    return;

                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteEventPhoto", user.Language, e.ApplicationID), eventPhoto.FriendlyFileName, eventThread.EventName);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_EventPhotoAuditingFail", user.Language, e.ApplicationID), eventPhoto.FriendlyFileName, eventThread.EventName);
            }
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, eventPhoto.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            if (role.HasTradePoints)
            {
                EventUserDatas.ChanageExperiencePoints(eventPhoto.UserID, role.TradePoints);
            }

            Points.CreateUserPointRecords(records);
        }

        /// <summary>
        /// ۳ֵ
        /// </summary>
        void em_AfterPointChangeOfEventThread(EventThread eventThread, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;

            if (userPointDirection == UserPointDirection.Output)
            {
                User user = Users.GetUser(eventThread.UserID, false);
                if (user == null)
                    return;
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteEvent());
                if (role == null)
                    return;

                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteEventThread", user.Language, e.ApplicationID), eventThread.EventName);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_EventThreadAuditingFail", user.Language, e.ApplicationID), eventThread.EventName);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, eventThread.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                if (role.HasTradePoints)
                {
                    EventUserDatas.ChanageExperiencePoints(eventThread.UserID, role.TradePoints);
                }

                Points.CreateUserPointRecords(records);
            }
        }

        #endregion

        /// <summary>
        /// ʱ˵ķ֣ߵĲ
        /// </summary>
        void em_EventFinished(EventThread eventThread, GlobalEventArgs e)
        {
            //δͨ˺ʹ״̬Ļ
            if (eventThread.AuditingStatus == AuditingStatuses.Pending || eventThread.AuditingStatus == AuditingStatuses.Fail)
                return;
            List<UserPointRecord> records = new List<UserPointRecord>();
            string userPointRecordDescription = string.Empty;

            #region 
            //߻ ֵ1/2Ϊ ֵ100%Ϊ
            User user = Users.GetUser(eventThread.UserID, false);
            if (user == null)
                return;

            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateEventThread", user.Language, e.ApplicationID), eventThread.EventName);
            string itemName = ResourceManager.GetString("Title_Pattern_Point_CreateEventThreadItemName", user.Language, e.ApplicationID);
            UserPointRecord record = new UserPointRecord();
            record.Description = userPointRecordDescription;
            record.PointCategory = UserPointCategory.Report;
            record.PointItemName = itemName;
            record.Points = eventThread.Points / 2;
            record.UserID = eventThread.UserID;
            records.Add(record);

            record = new UserPointRecord();
            record.Description = userPointRecordDescription;
            record.PointCategory = UserPointCategory.Trade;
            record.PointItemName = itemName;
            record.Points = eventThread.Points;
            record.UserID = eventThread.UserID;
            records.Add(record);

            EventUserDatas.ChanageExperiencePoints(eventThread.UserID, eventThread.Points);

            #endregion

            #region 
            UserPointItemRole role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().JoinEvent());
            if (role == null)
                return;
            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_JoinEvent", user.Language, e.ApplicationID), eventThread.EventName);
            Dictionary<int, int> dictionary = EventMembers.GetUserID2MemberIDDictionaryOfEvent(eventThread.EventID);
            foreach (var pair in dictionary)
            {
                EventMember eventMember = EventMembers.GetEventMember(pair.Value, false);
                if (eventMember != null && eventMember.IsApproved)
                    records.AddRange(Points.PopulateUserPointRecords(role, eventMember.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription));
                if (role.HasTradePoints)
                {
                    EventUserDatas.ChanageExperiencePoints(eventMember.UserID, role.TradePoints);
                }
            }
            #endregion

            Points.CreateUserPointRecords(records);
        }
    }
}