//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;

namespace SpaceBuilder.Event.Modules
{
    /// <summary>
    /// ƼϢصĻ
    /// </summary>
    public class DisposePointForReCommendedEvent : IServiceModule
    {
        #region IServiceModule Ա

        public void Init(ServiceEventManager gem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                gem.RecommendedItemChange += new RecommendedItemEventHandler(gem_RecommendedItemChange);
            }
        }
        #endregion


        void gem_RecommendedItemChange(RecommendedItem commendedItem, GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().Event()) && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(commendedItem.AuthorUserID, false);
                if (user == null)
                    return;
                List<UserPointRecord> records = new List<UserPointRecord>();
                string userPointRecordDescription = string.Empty;
                string itemKey = string.Empty;
                UserPointItemRole role = null;
                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_RecommendedEvent", user.Language, e.ApplicationID), commendedItem.ItemName);
                itemKey = UserPointItemKeys.Instance().RecommendedEvent();
                role = Points.GetUserPointItemRole(itemKey);
                records = Points.PopulateUserPointRecords(role, commendedItem.AuthorUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                if (role != null)
                {
                    if (role.HasTradePoints)
                    {
                        EventUserDatas.ChanageExperiencePoints(user.UserID, role.TradePoints);
                    }

                    Points.CreateUserPointRecords(records);
                }
            }
        }
    }
}