﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Event.Modules
{
    public class EventFavoriteStatistics : IServiceModule
    {
        #region IServiceModule 成员

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.FavoriteChange += new FavoriteEventHandler(em_FavoriteChange);
        }

        void em_FavoriteChange(Favorite favorite, string favoriteItemKey, ObjectState state)
        {
            if (favoriteItemKey.Equals(FavoriteItemKeys.Instance().EventThread()))
            {
                if (state == ObjectState.Create)
                {
                    EventThreads.ChangeFavoriteThreadCount(favorite.UserID, favorite.ItemID, FavirateCountDirection.Add);
                }
                else if (state == ObjectState.Delete)
                {
                    EventThreads.ChangeFavoriteThreadCount(favorite.UserID, favorite.ItemID, FavirateCountDirection.Sub);
                }
            }
        }

        #endregion
    }
}
