﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.Event.Modules
{
    public class EventMemberFormatting : IEventModule
    {
        #region IEventModule 成员

        public void Init(EventEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforEventMemberChange += new EventMemberEventHandler(em_BeforEventMemberChange);
        }

        void em_BeforEventMemberChange(EventMember eventMember, SpaceBuilder.Common.GlobalEventArgs e)
        {
            EventThread eventThread = EventThreads.GetEvent(eventMember.EventID, false);
            if (eventThread == null && !eventThread.IsAllowAnonymousUserSignUp)
                throw new SPBException(ExceptionTypes.Instance().AccessDenied());
            if (eventMember.UserID <= 0)
            {
                eventMember.DisplayName = Formatter.FormatSingleLinePlainTextForStorage(eventMember.DisplayName);
                eventMember.Company = Formatter.FormatSingleLinePlainTextForStorage(eventMember.Company);
                eventMember.Job = Formatter.FormatSingleLinePlainTextForStorage(eventMember.Job);
                eventMember.Address = Formatter.FormatSingleLinePlainTextForStorage(eventMember.Address);
            }
            eventMember.RequestBody = Formatter.FormatMultiLinePlainTextForStorage(eventMember.RequestBody, true);
            if (SPBConfig.Instance().EnableEmoticon)
                eventMember.RequestBody = EmotionManager.Instance().EmoticonTransforms(eventMember.RequestBody);
        }

        #endregion
    }
}
