﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.Event.Modules
{
    public class EventPhotoCommentFormatting : IEventModule
    {
        #region IEventModule 成员

        public void Init(EventEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforEventPhotoCommentChange += new EventPhotoCommentEventHandler(em_BeforEventPhotoCommentChange);
        }

        void em_BeforEventPhotoCommentChange(EventPhotoComment eventPhotoComment, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                eventPhotoComment.Author = Formatter.FormatSingleLinePlainTextForStorage(eventPhotoComment.Author);
                eventPhotoComment.Body = Formatter.FormatMultiLinePlainTextForStorage(eventPhotoComment.Body, true);

                if (SPBConfig.Instance().EnableEmoticon)
                    eventPhotoComment.Body = EmotionManager.Instance().EmoticonTransforms(eventPhotoComment.Body);
            }
        }

        #endregion
    }
}
