﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.Event.Modules
{
    public class EventPhotoFormatting : IEventModule
    {
        #region IEventModule 成员

        public void Init(EventEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforEventPhotoChange += new EventPhotoEventHandler(em_BeforEventPhotoChange);
        }

        void em_BeforEventPhotoChange(EventPhoto eventPhoto, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                eventPhoto.FriendlyFileName = Formatter.FormatSingleLinePlainTextForStorage(eventPhoto.FriendlyFileName);
                eventPhoto.Description = Formatter.FormatMultiLinePlainTextForStorage(eventPhoto.Description,true);

                if (SPBConfig.Instance().EnableEmoticon)
                    eventPhoto.Description = EmotionManager.Instance().EmoticonTransforms(eventPhoto.Description);
            }
        }

        #endregion
    }
}
