﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.Event.Modules
{
    public class EventPostFormatting : IEventModule
    {
        #region IEventModule 成员

        public void Init(EventEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforEventPostChange += new EventPostEventHandler(em_BeforEventPostChange);
        }

        void em_BeforEventPostChange(EventPost eventPost, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {

                eventPost.Body = Formatter.FormatPlainTextComment(eventPost.Body);

                if (SPBConfig.Instance().EnableEmoticon)
                    eventPost.Body = EmotionManager.Instance().EmoticonTransforms(eventPost.Body);
            }
        }


        #endregion
    }
}
