﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

using SpaceBuilder.Utils;

namespace SpaceBuilder.Event.Modules
{
    public class EventThreadFormatting : IEventModule
    {
        #region IEventModule 成员

        public void Init(EventEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeEventChange += new EventEventHandler(em_BeforeEventChange);
        }

        void em_BeforeEventChange(EventThread eventThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                #region 检查发帖时间间隔,防灌水
                if (e.State == ObjectState.Create)
                    Globals.CheckPostDate();
                #endregion

                eventThread.EventName = Formatter.FormatSingleLinePlainTextForStorage(eventThread.EventName);
                eventThread.Location = Formatter.FormatSingleLinePlainTextForStorage(eventThread.Location);
                eventThread.PayDescription = Formatter.FormatSingleLinePlainTextForStorage(eventThread.PayDescription);
                eventThread.BodyForDataTransmission = HtmlScrubber.Clean(eventThread.BodyForDataTransmission, false, true);

                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    //过滤掉敏感词语                    
                    eventThread.BodyForDataTransmission = Censors.CensorPost(eventThread.BodyForDataTransmission);
                }
            }
        }

        #endregion
    }
}
