﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Event.Modules
{
    public class ToggleTemporaryAttachmentsForEvent : IEventModule
    {
        #region IEventModule 成员

        public void Init(EventEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterEventChange += new EventEventHandler(em_AfterEventChange);
        }

        void em_AfterEventChange(EventThread EventThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                EventAttachmentManager.Instance().ToggleTemporaryAttachments(EventThread.EventID, EventThread.UserID, null);
            }
        }

        #endregion
    }
}