﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;


using SpaceBuilder.Utils;
using System.Web.Mvc;
using SpaceBuilder.Web;
using SpaceBuilder.Common;

namespace SpaceBuilder.Event
{
    public static class SPBHtmlHelperExtensions
    {
        ///<overloads>显示活动logo</overloads>
        /// <summary>
        /// 显示活动logo
        /// </summary>
        /// <param name="clubID">活动ID</param>
        /// <param name="width">图片宽度</param>
        /// <param name="height">图片高度</param>
        /// <returns></returns>
        public static string ShowEventLogo(this SPBHtmlHelper sPBHtmlHelper, int eventID, EventPhotoTypes eventPhotoType)
        {
            return ShowEventLogo(sPBHtmlHelper, eventID, false, null, eventPhotoType);
        }

        ///<overloads>显示活动logo</overloads>
        /// <summary>
        /// 显示活动logo
        /// </summary>
        /// <param name="clubID">活动ID</param>
        /// <param name="enableNavigate">是否允许链接到活动首页</param>
        /// <param name="navigateTarget">frameName 或者 _blank,_parent,_search,_self,_top</param>
        /// <param name="width">图片宽度</param>
        /// <param name="height">图片高度</param>
        /// <returns></returns>
        public static string ShowEventLogo(this SPBHtmlHelper sPBHtmlHelper, int eventID, bool enableNavigate, string navigateTarget, EventPhotoTypes eventPhotoType)
        {
            EventThread eventThread = EventThreads.GetEvent(eventID,false);
            if (eventThread == null)
                return string.Empty;
            else
                return ShowEventLogo(sPBHtmlHelper, eventThread, enableNavigate, navigateTarget, eventPhotoType);
        }

        ///<overloads>显示活动logo</overloads>
        /// <summary>
        /// 显示活动logo
        /// </summary>
        public static string ShowEventLogo(this SPBHtmlHelper sPBHtmlHelper, EventThread eventThread, EventPhotoTypes eventPhotoType)
        {
            return ShowEventLogo(sPBHtmlHelper, eventThread, false, null, eventPhotoType);
        }


        ///<overloads>显示活动logo</overloads>
        /// <summary>
        /// 显示活动logo
        /// </summary>
        /// <param name="eventThread">EventThread</param>
        /// <param name="enableNavigate">是否允许链接到活动首页</param>
        /// <param name="navigateTarget">frameName 或者 _blank,_parent,_search,_self,_top</param>
        /// <param name="width">图片宽度</param>
        /// <param name="height">图片高度</param>
        /// <returns></returns>
        public static string ShowEventLogo(this SPBHtmlHelper sPBHtmlHelper, EventThread eventThread, bool enableNavigate, string navigateTarget, EventPhotoTypes eventPhotoType)
        {
            if (eventThread == null)
                return string.Empty;

            TagBuilder img = new TagBuilder("img");
            int featuredPhotoID = 0;
            EventPhoto photo = EventPhotos.GetEventPhoto(eventThread.FeaturedPhotoID, false);
            if (photo != null)
                featuredPhotoID = eventThread.FeaturedPhotoID;
            img.MergeAttribute("src", WebUtils.ResolveUrl(SiteUrls.Instance().EventPhotoUrl(eventThread.FeaturedPhotoID, eventPhotoType)));
            img.MergeAttribute("alt", eventThread.EventName);

            if (enableNavigate && eventThread.IsPublic)
            {
                TagBuilder a = new TagBuilder("a");
                a.MergeAttribute("href", SiteUrls.Instance().ShowEvent(eventThread.EventID));

                if (!string.IsNullOrEmpty(navigateTarget))
                    a.MergeAttribute("target", navigateTarget);

                a.InnerHtml = img.ToString(TagRenderMode.SelfClosing);

                return a.ToString();
            }
            else
            {
                return img.ToString(TagRenderMode.SelfClosing);
            }
        }

        /// <summary>
        /// 获取博客附件的缩略图
        /// </summary>
        public static string ShowEventAttachmentThumbnail(this SPBHtmlHelper spbHtmlHelper, Attachment attachment, ContentTypeThumbnailSize thumbnailSize)
        {
            return spbHtmlHelper.ShowAttachmentThumbnail(attachment, thumbnailSize, SiteUrls.Instance().EventPhotoUrl);
        }
    }
}

