﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights  reserved.
// </copyright> 
//------------------------------------------------------------------------------ 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Event
{
    public static class SiteUrlsExtensions
    {
        /// <summary>
        /// 活动频道首页
        /// </summary>
        public static string ChannelEventHome(this SiteUrls siteUrls)
        {
            return SPBUrlHelper.RouteUrl("Channel_Event_Home");
        }

        #region Event

        /// <summary>
        /// 显示活动
        /// </summary>
        public static string ShowEvent(this SiteUrls siteUrls, int eventID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Event_ShowEvent", new RouteValueDictionary { { "action", "ShowEvent" }, { "eventID", eventID } });
        }
        /// <summary>
        /// 获取加密的活动链接
        /// </summary>
        public static string ShowEvent(this SiteUrls siteUrls, int eventID, int userID)
        {
            string token = EventThreads.EncryptInvitationTicket(eventID, userID);
            return SPBUrlHelper.RouteUrl("Channel_Event_ShowEvent", new RouteValueDictionary { { "action", "ShowEvent" }, { "eventID", eventID }, { "token", token } });
        }
        /// <summary>
        /// 显示活动照片
        /// </summary>
        public static string ShowEventPhoto(this SiteUrls siteUrls, int attachmentID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Event_Common", new RouteValueDictionary { { "action", "ShowEventPhoto" }, { "attachmentID", attachmentID } });
        }
        /// <summary>
        /// 显示管理活动成员页
        /// </summary>
        public static string ManageEventMembers(this SiteUrls siteUrls, int eventID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Event_Common", new RouteValueDictionary { { "action", "ManageEventMembers" }, { "eventID", eventID } });
        }

        /// <summary>
        /// 删除活动附件Url
        /// </summary>
        public static string DeleteEventAttachmentUrl(this SiteUrls siteUrls, int attachmentID, bool? isImage)
        {
            return SPBUrlHelper.RouteUrl("Common", new RouteValueDictionary { { "controller", "ChannelEvent" }, { "action", "DeleteEventAttachment" }, { "attachmentID", attachmentID } });
        }

        /// <summary>
        /// 根据活动图片photoID获取图片Url
        /// </summary>
        public static string EventPhotoUrl(this SiteUrls siteUrls, int attachmentID)
        {
            return EventPhotoUrl(siteUrls, attachmentID, EventPhotoTypes.Original);
        }

        /// <summary>
        /// 根据活动图片photoID获取图片Url
        /// </summary>
        public static string EventPhotoUrl(this SiteUrls siteUrls, int attachmentID, EventPhotoTypes photoType)
        {
            EventPhoto photo = EventPhotos.GetEventPhoto(attachmentID, false);
            if (photo == null)
            {
                switch (photoType)
                {
                    case EventPhotoTypes.Logo:
                        return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/event_nophoto120.gif");
                    case EventPhotoTypes.SmallLogo:
                        return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/event_nophoto46.gif");

                    case EventPhotoTypes.Details:
                    case EventPhotoTypes.Original:
                    case EventPhotoTypes.Thumbnail:
                        return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/event_nophoto100.png");
                    default:
                        return string.Empty;
                }
            }

            User currentUser = Globals.GetCurrentUser();

            if (photo.AuditingStatus == AuditingStatuses.Fail && (currentUser == null || (!currentUser.IsAdministrator && !currentUser.IsContentAdministrator)))
                return string.Empty;

            if (FileStorageProvider.Instance(EventAttachmentManager.Instance().StorageProviderName).EnableDirectlyUrl)
            {
                if (photoType == EventPhotoTypes.Details || photoType == EventPhotoTypes.Original)
                {
                    if (!SpaceBuilder.Event.Handlers.EventPhotoHandler.CanUserView(photo, Globals.GetCurrentUser()))
                        return string.Empty;
                }
                return EventAttachmentManager.Instance().GetDirectlyUrl(photo, photoType);
            }

            return WebUtils.ResolveUrl(string.Format("~/Services/Event/EventPhoto.ashx?attachmentID={0}&photoType={1}", attachmentID, photoType));
        }

        /// <summary>
        /// 导出活动成员名单
        /// </summary>
        public static string ExportEventMembersToCSV(this SiteUrls siteUrls, int eventID, bool? isApproved)
        {
            if (isApproved == null)
                return WebUtils.ResolveUrl(string.Format("~/Services/Event/ExportEventMembersToCSV.ashx?eventID={0}", eventID));
            else
                return WebUtils.ResolveUrl(string.Format("~/Services/Event/ExportEventMembersToCSV.ashx?eventID={0}&isApproved={1}", eventID, isApproved));
        }
        /// <summary>
        /// 根据类别显示活动列表
        /// </summary>
        /// <param name="categoryID"></param>
        /// <returns></returns>
        public static string ListEventsByCategoryID(this SiteUrls siteUrls, int siteCategoryID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Event_Common", new RouteValueDictionary { { "action", "Search" }, { "siteCategoryID", siteCategoryID } });
        }
        /// <summary>
        /// 根据地区显示活动列表
        /// </summary>
        /// <param name="areaCode"></param>
        /// <returns></returns>
        public static string ListEventsByAreaCode(this SiteUrls siteUrls, string areaCode)
        {
            return SPBUrlHelper.RouteUrl("Channel_Event_Common", new RouteValueDictionary { { "action", "Search" }, { "areaCode", areaCode } });
        }

        ///// <summary>
        ///// 发送活动邀请
        ///// </summary>
        ///// <param name="userDomainName">当前登录用户的DomainName</param>
        ///// <param name="relativeItemID">活动ID</param>
        ///// <returns></returns>
        //public static string CreateJoinEventInvitation(string userDomainName, int relativeItemID)
        //{
        //    return WebUtils.ResolveUrl(string.Format("~/u/{0}/Communication.aspx/NewJoinEventInvitation?RelativeItemID={1}", userDomainName, relativeItemID));
        //}


        #endregion

    }
}
