﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.File
{
    public static class FileUserCookie
    {
        private static readonly string DownloadFileThreadID = "DownloadFileThreadID";

        private static readonly char FileCookieKeyValueSeparator = ',';
        private static readonly char FileCookieContentSeparator = '|';

        private static readonly string AuthorizedFileThreadCookieKey = "AuthorizedFileThreads";

        /// <summary>
        /// 保存已授权的博客文章ID集合
        /// </summary>
        public static void SaveAuthorizedFileThreadIDs(this UserCookie userCookieObject, int threadID, string password)
        {
            //检测是否已存在于Cookie中
            if (userCookieObject.AuthorizeFileThreadID(threadID))
                return;
            if (userCookieObject.Cookie != null)
            {
                string oldthreadIDs = userCookieObject.Cookie[AuthorizedFileThreadCookieKey];
                userCookieObject.Cookie[AuthorizedFileThreadCookieKey] = EncryptManager.EncryptTokenForInviteFriend(string.Format("{0}{1}{2},{3}", oldthreadIDs, FileCookieContentSeparator, threadID.ToString(), password));
                userCookieObject.WriteCookie();
            }
        }

        /// <summary>
        /// 获取已授权的博客文章ID集合
        /// </summary>
        /// <returns>
        /// 例如：1,2,6,
        /// </returns>
        public static bool AuthorizeFileThreadID(this UserCookie userCookieObject, int threadID)
        {
            if (userCookieObject.Cookie == null)
                return false;

            FileThread thread = FileThreads.GetThread(threadID, null, true);
            if (thread == null)
                return false;

            string threadIDs = EncryptManager.DecryptTokenForInviteFriend(userCookieObject.Cookie[AuthorizedFileThreadCookieKey]);
            if (!string.IsNullOrEmpty(threadIDs))
            {
                string[] fileThreadsArray = threadIDs.Split(new char[] { FileCookieContentSeparator }, StringSplitOptions.RemoveEmptyEntries);
                if (fileThreadsArray != null && fileThreadsArray.Length > 0)
                {
                    Dictionary<int, string> fileThreads = new Dictionary<int, string>();
                    foreach (string threadStr in fileThreadsArray)
                    {
                        string[] items = threadStr.Split(new char[] { FileCookieKeyValueSeparator }, StringSplitOptions.RemoveEmptyEntries);
                        if (items != null && items.Length > 1)
                        {
                            int i = 0;
                            int.TryParse(items[0], out i);
                            if (i > 0)
                                fileThreads[i] = items[1];
                        }
                    }
                    return fileThreads.ContainsKey(threadID) && FileThreads.ValidPrivacyPassword(fileThreads[threadID], thread.Password);
                }
            }
            return false;
        }


        /// <summary>
        /// 保存 已下载文件theadIDs
        /// </summary>
        public static void SaveDownloadFileThreadID(this UserCookie userCookieObject, int threadID)
        {
            if (userCookieObject.Cookie != null)
            {
                string oldFileThreadIDs = userCookieObject.Cookie[DownloadFileThreadID];

                userCookieObject.Cookie[DownloadFileThreadID] =oldFileThreadIDs+ threadID.ToString()+",";
                userCookieObject.WriteCookie();
            }
        }



        /// <summary>
        /// 获取当前用户已下载文件ThreadID集合
        /// </summary>
        public  static List<int> GetDownloadFileThreadIDs(this UserCookie userCookieObject)
        {
            List<int> downloadThreadIDs = new List<int>();
            string downloadThreadIDsString = string.Empty;
            if (userCookieObject.Cookie != null)
                downloadThreadIDsString= userCookieObject.Cookie[DownloadFileThreadID];
            string[] downloadThreadsArray = downloadThreadIDsString.Split(',');
            foreach (string threadIDString in downloadThreadsArray)
            {
                if (!string.IsNullOrEmpty(threadIDString))
                    downloadThreadIDs.Add(Convert.ToInt32(threadIDString));
            }

            return downloadThreadIDs;
        }

    }
}
