﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;

using System.IO;
using SpaceBuilder.Common;
using SpaceBuilder.Common.Handlers;

namespace SpaceBuilder.File.Handlers
{
    /// <summary>
    /// 处理文件附件下载
    /// </summary>
    public class AttachmentHandler : DownloadFileHandlerBase
    {
        public override void ProcessRequest(HttpContext context)
        {
            //防盗链检测
            if (SPBConfig.Instance().EnableAntiLeech && !Globals.IsAllowableReferrer(context.Request))
            {
                context.Response.Redirect(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/anti-Leech.gif"), true);
                return;
            }

            int attachmentID = context.Request.QueryString.GetInt("AttachmentID", -1);
            if (attachmentID <= 0)
            {
                WebUtils.Return404(context);
                return;
            }

            Attachment attachment = FileAttachmentManager.Instance().GetAttachment(attachmentID, true);
            if (attachment == null)
            {
                WebUtils.Return404(context);
                return;
            }

            FileThread fileThread = FileThreads.GetThread(attachment.AssociateID, false);
            User currentUser = Globals.GetCurrentUser();
            // 处理不同情况 
            if (fileThread == null)
            {
                WebUtils.Return404(context);
                return;
            }

            if (!FileThreads.ValidateDownloadFile(currentUser, fileThread.ThreadID))
            {
                WebUtils.Return404(context);
                return;
            }

            if (fileThread.PrivacyStatus == PrivacyStatuses.NeedPassword && (currentUser == null || (!currentUser.IsContentAdministrator && fileThread.OwnerUserID != currentUser.UserID)))
            {
                UserCookie userCookie = new UserCookie(currentUser, context);

                if (!userCookie.AuthorizeFileThreadID(fileThread.ThreadID))
                {
                    WebUtils.Return404(context);
                    return;
                }
            }
            //创建下载记录
            if (currentUser == null || !FileThreads.IsDownloaded(currentUser.UserID, fileThread.ThreadID))
            {
                FileThreads.CreateDownLoadRecord(currentUser, fileThread.ThreadID, context.Request.UrlReferrer.ToString());
            }

            //下载计数 attachmentID=threadID          
            CounterFactory.IncreaseCount<FileThreadCounter>(IncreasableCountTypes.Download, fileThread.ThreadID);

            ////如果启用分布式文件存储 则直接返回到文件服务器
            //FileAttachmentSettings fileAttachmentSettings = FileSectionConfiguration.Instance().AttachmentSettings;
            //if (fileAttachmentSettings.FileIsDistributedStorage)
            //{
            //    string fileRelativePath = MakeFileRelativePath(attachment.AssociateID, attachment.FileName);
            //    string returnUrl = GetNginxLinkModuleUrl(fileAttachmentSettings.FileDistributedUrlHost, fileRelativePath, fileAttachmentSettings.FileDistributedUrlSecret);
            //    context.Response.Redirect(returnUrl, true);
            //    return;
            //}

            DateTime lastModified = attachment.DateCreated.ToUniversalTime();
            if (IsCacheOK(context, lastModified))
            {
                WebUtils.Return304(context);
                return;
            }
            else
            {
                //attachment.FriendlyFileName 是文件主题不包含后缀
                string fileextname = fileThread.FileName.Substring(fileThread.FileName.LastIndexOf('.') + 1);
                SetResponsesDetails(context, attachment.ContentType, fileThread.Subject + "." + fileextname, lastModified);

                FileSystemFile fileSystemFile = attachment.File as FileSystemFile;
                if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                {
                    // Send files stored on UNC paths explicitly to avoid a bug with TransmitFile.
                    context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                }
                else
                {
                    context.Response.AddHeader("Content-Length", fileSystemFile.ContentLength.ToString("0"));
                    context.Response.Buffer = false;
                    context.Response.BufferOutput = false;

                    Stream stream = null;
                    try
                    {
                        stream = attachment.OpenReadStream();
                        if (stream == null)
                        {
                            WebUtils.Return404(context);
                            return;
                        }

                        int bufferLength = fileSystemFile.ContentLength <= DownloadFileHandlerBase.BufferLength ? fileSystemFile.ContentLength : DownloadFileHandlerBase.BufferLength;
                        byte[] buffer = new byte[bufferLength];
                        int readedSize;
                        while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                        {
                            if (!context.Response.IsClientConnected)
                                break;

                            context.Response.OutputStream.Write(buffer, 0, readedSize);
                            context.Response.OutputStream.Flush();
                        }

                        context.Response.OutputStream.Flush();
                        context.Response.Flush();
                    }
                    catch (Exception ex)
                    {
                        context.Response.Redirect(SiteUrls.Instance().Error(ex.ToString()), true);
                        return;
                    }
                    finally
                    {
                        if (stream != null)
                            stream.Close();
                    }
                }
                context.Response.Cache.VaryByParams["AttachmentID"] = true;
                context.Response.End();
            }
        }
    }
}