﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;

using SpaceBuilder.Common;
using System.IO;
using System.Web;
using SpaceBuilder.Common.Handlers;

namespace SpaceBuilder.File.Handlers
{
    public class FileFeaturedImageHandler : DownloadFileHandlerBase
    {
        public override void ProcessRequest(HttpContext context)
        {
            //防盗链检测
            if (SPBConfig.Instance().EnableAntiLeech && !Globals.IsAllowableReferrer(context.Request))
            {
                context.Response.Redirect(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/anti-Leech.gif"), true);
                return;
            }

            int attachmentID = -1;
            if (!string.IsNullOrEmpty(context.Request.QueryString["AttachmentID"]))
                int.TryParse(context.Request.QueryString["AttachmentID"], out attachmentID);

            if (attachmentID <= 0)
            {
                WebUtils.Return404(context);
                return;
            }

            Attachment attachment = FileFeaturedImageManager.Instance().GetAttachment(attachmentID, true);
            if (attachment == null)
            {
                WebUtils.Return404(context);
                return;
            }

            FileFeaturedImageTypes imageType = FileFeaturedImageTypes.Title;
            if (!string.IsNullOrEmpty(context.Request.QueryString["imageType"]))
            {
                try
                {
                    imageType = (FileFeaturedImageTypes)Enum.Parse(typeof(FileFeaturedImageTypes), context.Request.QueryString["imageType"], true);
                }
                catch { }
            }

            IFile file = FileFeaturedImageManager.Instance().GetResizedPhoto(attachment, imageType);
            if (file == null)
            {
                WebUtils.Return404(context);
                return;
            }

            DateTime lastModified = file.LastModified.ToUniversalTime();
            if (IsCacheOK(context, lastModified))
            {
                WebUtils.Return304(context);
                return;
            }
            else
            {
                SetResponsesDetails(context, attachment.ContentType, attachment.FriendlyFileName, lastModified);
                FileSystemFile fileSystemFile = file as FileSystemFile;
                if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                {
                    // Send files stored on UNC paths explicitly to avoid a bug with TransmitFile.
                    context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                }
                else
                {
                    context.Response.AddHeader("Content-Length", file.ContentLength.ToString("0"));
                    using (Stream stream = file.OpenReadStream())
                    {
                        if (stream == null)
                        {
                            WebUtils.Return404(context);
                            return;
                        }

                        int bufferLength = file.ContentLength <= DownloadFileHandlerBase.BufferLength ? file.ContentLength : DownloadFileHandlerBase.BufferLength;
                        byte[] buffer = new byte[bufferLength];
                        int readedSize;
                        while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                        {
                            if (!context.Response.IsClientConnected)
                                break;

                            context.Response.OutputStream.Write(buffer, 0, readedSize);
                        }

                        stream.Close();
                        stream.Dispose();

                        context.Response.OutputStream.Flush();
                        context.Response.Flush();
                    }
                }
            }

            context.Response.Cache.VaryByParams["AttachmentID"] = true;
            context.Response.Cache.VaryByParams["imageType"] = true;
            context.Response.End();
        }

    }
}
