﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Web.Mvc;


namespace SpaceBuilder.File.Handlers
{
    class UploadFeaturedImagesHandler : IHttpHandler
    {
        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));
            int currentThreadID = Convert.ToInt32(context.Request["associateID"]);

            // 判断用户是否有上传图片的权限
            if (currentUserID < 1)
            {
                WebUtils.Return404(context);
                return;
            }

            User currentUser = Users.GetUser(currentUserID, false);
            if (currentUser == null)
            {
                WebUtils.Return404(context);
                return;
            }

            FileThread currentThread = null;
            if (currentThreadID > 0)
            {
                currentThread = FileThreads.GetThread(currentThreadID, null, false);
                if (currentThread == null)
                {
                    WebUtils.Return404(context);
                    return;
                }
            }

            bool isPermitted = true;
            System.Web.HttpPostedFile postedFile = context.Request.Files["Filedata"];

            if (postedFile.ContentLength > FileSectionConfiguration.Instance().FeaturedImageSettings.MaxAttachmentSize * 1024)
            {
                WebUtils.Return404(context);
                return;
            }

            if (!string.IsNullOrEmpty(postedFile.FileName))
            {
                string fileTypeString = postedFile.FileName.Substring(postedFile.FileName.LastIndexOf(".") + 1);
                string uploadPhotoTypes = FileSectionConfiguration.Instance().FeaturedImageSettings.Extensions;
                string[] types = uploadPhotoTypes.ToLower().Split(new char[] { ',', '，' }, StringSplitOptions.RemoveEmptyEntries);
                isPermitted = types.Contains(fileTypeString.ToLower());
            }
            if (!currentUser.IsContentAdministrator && postedFile.ContentLength / 1024 > (currentUser.DatabaseQuota - currentUser.DatabaseQuotaUsed))
            {
                context.Response.StatusCode = 200;
                context.Response.Write("{message:'空间容量不足'}");
                context.Response.End();
            }
            if (isPermitted)
            {
                Attachment attachment = new Attachment(FileFeaturedImageManager.Instance().StorageProviderName, postedFile.FileName);
                attachment.OwnerID = currentUser.UserID;
                attachment.UserID = currentUser.UserID;
                attachment.ContentSize = postedFile.ContentLength;
                attachment.ContentType = MimeTypeConfiguration.GetMimeType(postedFile.FileName);
                attachment.DateCreated = DateTime.Now;
                //blogAttachment.FileName = postedFile.FileName;
                attachment.FriendlyFileName = postedFile.FileName;


                if (currentThreadID > 0)
                {
                    attachment.AssociateID = currentThreadID;
                    FileFeaturedImageManager.Instance().CreateAttachment(attachment, postedFile.InputStream);
                }
                else
                {
                    FileFeaturedImageManager.Instance().CreateTemporaryAttachment(attachment, postedFile.InputStream);
                }

          
            }
            context.Response.StatusCode = 200;
            context.Response.Write("{ok:true}");
            context.Response.End();
        }

        #endregion
    }
}
