﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common.Handlers;
using System.Web;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;


namespace SpaceBuilder.File.Handlers
{
    public class UploadFilesHandler : IHttpHandler
    {

        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return true; }
        }

        public void ProcessRequest(HttpContext context)
        {
            // 判断用户是否有上传文件的权限
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));

            User currentUser = Users.GetUser(currentUserID, false);
            if (!(currentUser.IsContentAdministrator || (currentUser.UserID == Convert.ToInt32(context.Request["associateID"]))))
                return;

            bool isPermitted = true;



            if (!string.IsNullOrEmpty(context.Request.Files["Filedata"].FileName))
            {
                string fileTypeString = context.Request.Files["Filedata"].FileName.Substring(context.Request.Files["Filedata"].FileName.LastIndexOf(".") + 1);
                string uploadPhotoTypes = FileAttachmentManager.Instance().Settings.Extensions;
                string[] types = uploadPhotoTypes.ToLower().Split(new char[] { ',', '，' }, StringSplitOptions.RemoveEmptyEntries);
                isPermitted = types.Contains(fileTypeString.ToLower());
            }

            if (context.Request.Files["Filedata"].ContentLength > FileAttachmentManager.Instance().Settings.MaxAttachmentSize * 1024)
            {
                WebUtils.Return404(context);
                return;
            }
            if (!currentUser.IsContentAdministrator && context.Request.Files["Filedata"].ContentLength / 1024 > (currentUser.DatabaseQuota - currentUser.DatabaseQuotaUsed))
            {
                context.Response.StatusCode = 200;
                context.Response.Write("{message:'空间容量不足'}");
                context.Response.End();
            }

            if (isPermitted)
            {
                FileThread fileThread = new FileThread();
                fileThread.OwnerUserID = Convert.ToInt32(context.Request["associateID"]);
                //List<string> selectedTagNames = new List<string>();

                if (fileThread.OwnerUserID > 0 && Users.GetUser(fileThread.OwnerUserID, false) != null)
                {
                    fileThread.Author = Users.GetUser(fileThread.OwnerUserID, false).DisplayName;
                    //fileThread.SiteCategoryID = Convert.ToInt32(context.Request["fileSiteCategoryDDL"]);
                    //fileThread.UserCategoryID = Convert.ToInt32(context.Request["fileUserCategoryDDL"]);
                    //List<UserTag> selectedUserTags = new List<UserTag>();

                    //if (!string.IsNullOrEmpty(Convert.ToString(context.Request["userTags"])))
                    //{
                    //    string[] tagNames = (Convert.ToString(context.Request["userTags"])).Split(',', ' ');
                    //    if (tagNames != null && tagNames.Length > 0)
                    //    {
                    //        foreach (string tagName in tagNames)
                    //        {
                    //            if (!string.IsNullOrEmpty(tagName.Trim()))
                    //            {
                    //                UserTag tag = UserTagManager.Instance(UserTagItemKeys.Instance().File()).GetUserTag(tagName.Trim(), fileThread.OwnerUserID, false);
                    //                if (tag == null)
                    //                {
                    //                    UserTag newTag = new UserTag();
                    //                    newTag.UserID = fileThread.OwnerUserID;
                    //                    newTag.TagName = StringUtils.Trim(tagName, 8, string.Empty);
                    //                    newTag.TagName = Formatter.CleanTagName(newTag.TagName);
                    //                    newTag.TagName = Formatter.FormatSingleLinePlainTextForStorage(newTag.TagName);

                    //                    if (UserTagManager.Instance(UserTagItemKeys.Instance().File()).CreateUserTag(newTag))
                    //                    {
                    //                        selectedTagNames.Add(newTag.TagName);
                    //                        selectedUserTags.Add(newTag);
                    //                    }
                    //                }
                    //                else
                    //                {
                    //                    selectedTagNames.Add(tag.TagName);
                    //                    selectedUserTags.Add(tag);
                    //                }
                    //            }
                    //        }
                    //    }
                    //}

                    //fileThread.PrivacyStatus = (PrivacyStatuses)Convert.ToInt32(context.Request["setFilePirvacyStatus"]);
                    //fileThread.OnlyAllowRegisteredUserDownload = Convert.ToBoolean(context.Request["onlyAllowRegisteredUserDownload"]);
                    //fileThread.Password = Convert.ToString(context.Request["setFilePirvacyStatus_Password"]);
                    //fileThread.Price = Convert.ToInt32(context.Request["requiredPoints"]);

                    //创建的时候使有各种属性！
                    Attachment attachment = new Attachment(FileAttachmentManager.Instance().StorageProviderName, null);
                    attachment.ContentSize = context.Request.Files["Filedata"].ContentLength;

                    attachment.DateCreated = DateTime.Now;
                    attachment.FriendlyFileName = context.Request.Files["Filedata"].FileName;
                    attachment.ContentType = MimeTypeConfiguration.GetMimeType(attachment.FriendlyFileName);
                    fileThread.ContentType = attachment.ContentType;
                    fileThread.Attachment = attachment;
                    fileThread.Subject = attachment.FriendlyFileName.Substring(0, attachment.FriendlyFileName.LastIndexOf('.'));

                    FileThreads.CreateThread(fileThread, null, context.Request.Files["Filedata"].InputStream);

                    //if (selectedTagNames.Count > 0)
                    //    UserTagManager.Instance(UserTagItemKeys.Instance().File()).UpdateUserTagsOfItem(fileThread.ThreadID, fileThread.OwnerUserID, selectedTagNames);
                }
            }
            context.Response.StatusCode = 200;
            context.Response.Write("{ok:true}");
            context.Response.End();
        }

        #endregion

    }
}
