﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.File.Modules
{
    /// <summary>
    /// 删除用户时删除文件
    /// </summary>
    public class DisposeFileForDeleteUser : IGlobalModule
    {

        #region IGlobalModule 成员

        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.UserDelete += new UserDeleteEventHandler(gem_UserDelete);

            gem.UserDeleteAndReassignContent += new UserDeleteEventHandler(gem_UserDeleteAndReassignContent);
        }

        void gem_UserDeleteAndReassignContent(User user, string reassignUserName)
        {
            try
            {
                FileThreads.DeleteUserAndReassignContent(user.UserID, reassignUserName);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("删除用户并转移其文件内容时出现错误", e);
            }
        }

        void gem_UserDelete(User user, string reassignUserName)
        {
            try
            {
                if (user.UserType == UserTypes.PersonUser)
                    FileThreads.DeleteUser(user.UserID);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("删除用户并转移其文件内容时出现错误", e);
            }
        }
        #endregion
    }
}
